/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.item.misc.TooltipItem;
import net.tslat.aoa3.content.item.misc.summoning.BossTokenItem;
import net.tslat.aoa3.content.world.teleporter.AoAPortal;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;

public abstract class BossSpawningItem<T extends Entity>
extends TooltipItem
implements BossTokenItem {
    public BossSpawningItem() {
        this(2, new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public BossSpawningItem(int tooltipLines, Item.Properties itemProperties) {
        super(tooltipLines, itemProperties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 60;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (WorldUtil.isWorld(level, AoADimensions.NOWHERE)) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TELParticlePacket packet = new TELParticlePacket();
            for (int i = 0; i < 3; ++i) {
                float colorMod = level.random.nextFloat() * 0.7f + 0.3f;
                packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)((ParticleOptions)AoAParticleTypes.GENERIC_DUST.get()), (Entity)livingEntity).colourOverride(colorMod * 209.0f / 255.0f, colorMod * 177.0f / 255.0f, 0.0f, 1.0f));
            }
            packet.sendToAllNearbyPlayers(serverLevel, livingEntity.position(), 20.0);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                if (WorldUtil.isWorld(level, AoADimensions.NOWHERE) || !(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (entity instanceof ServerPlayer) break block5;
            }
            return stack;
        }
        ServerPlayer pl = (ServerPlayer)entity;
        ServerLevel nowhere = serverLevel.getServer().getLevel(AoADimensions.NOWHERE);
        if (nowhere == null) {
            return stack;
        }
        AoAScheduler.scheduleSyncronisedTask(() -> {
            if (AdvancementUtil.isAdvancementCompleted(pl, AdventOfAscension.id("nowhere/root"))) {
                ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                GlobalPos returnLoc = plData.storage.getPortalReturnFor((ResourceKey<Level>)nowhere.dimension());
                pl.changeDimension(AoAPortal.getTransitionForLevel(nowhere, (Entity)pl, (Block)AoABlocks.NOWHERE_PORTAL.get()));
                pl.connection.teleport(17.5, 502.5, 3.5, 0.0f, pl.getXRot());
                if (returnLoc != null) {
                    plData.storage.setPortalReturnLocation((ResourceKey<Level>)nowhere.dimension(), returnLoc);
                }
            } else {
                PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.setPortalReturnLocation((ResourceKey<Level>)nowhere.dimension(), (ResourceKey<Level>)pl.level().dimension(), pl.blockPosition());
                pl.changeDimension(AoAPortal.getTransitionForLevel(nowhere, (Entity)pl, (Block)AoABlocks.NOWHERE_PORTAL.get()));
                pl.connection.teleport(17.5, 452.5, 3.5, 0.0f, pl.getXRot());
            }
        }, 1);
        return stack;
    }
}

