/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.boss.tyrosaur.TyrosaurEntity;
import net.tslat.aoa3.content.entity.boss.tyrosaur.WoundedTyrosaurEntity;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;

public class BoneHorn
extends BossSpawningItem<TyrosaurEntity> {
    public BoneHorn() {
        super(0, new Item.Properties().rarity(Rarity.RARE).durability(3).setNoRepair());
    }

    public TyrosaurEntity spawnBoss(ServerLevel level, Vec3 position, ItemStack stack, int playerCount) {
        TyrosaurEntity tyrosaur = (TyrosaurEntity)EntitySpawningUtil.spawnEntity(level, (EntityType)AoAMonsters.TYROSAUR.get(), position, MobSpawnType.TRIGGERED);
        if (playerCount > 1 && tyrosaur != null) {
            AttributeUtil.applyPermanentModifier((LivingEntity)tyrosaur, (Holder<Attribute>)Attributes.MAX_HEALTH, this.getPerPlayerHealthBuff(playerCount));
            tyrosaur.setHealth(tyrosaur.getMaxHealth());
        }
        return tyrosaur;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 63;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return !enchantment.is(Enchantments.MENDING) && super.supportsEnchantment(stack, enchantment);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getDamageValue() > 1) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        player.startUsingItem(hand);
        new SoundBuilder((Holder<SoundEvent>)AoASounds.ITEM_BONE_HORN_CALL).followEntity((Entity)player).execute();
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    @Override
    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!stack.isDamaged()) {
            super.onUseTick(level, livingEntity, stack, remainingUseDuration);
        }
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return stack.isDamaged() ? UseAnim.TOOT_HORN : super.getUseAnimation(stack);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (stack.isDamaged()) {
            if (stack.getDamageValue() == 1) {
                if (level.dimension() == AoADimensions.PRECASIA && level instanceof ServerLevel) {
                    WoundedTyrosaurEntity tyrosaur;
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockPos spawnPos = RandomUtil.getRandomPositionWithinRange((BlockPos)entity.blockPosition(), (int)30, (int)10, (int)30, (int)10, (int)0, (int)10, (boolean)true, (Level)level, (int)10, (state, pos) -> level.getBlockState(pos.below()).isValidSpawn((BlockGetter)level, pos.below(), (EntityType)AoAMonsters.WOUNDED_TYROSAUR.get()) && level.noCollision(((EntityType)AoAMonsters.WOUNDED_TYROSAUR.get()).getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5)));
                    if (spawnPos != entity.blockPosition() && (tyrosaur = (WoundedTyrosaurEntity)EntitySpawningUtil.spawnEntity(serverLevel, (EntityType)AoAMonsters.WOUNDED_TYROSAUR.get(), (Vec3i)spawnPos, MobSpawnType.TRIGGERED)) != null) {
                        BrainUtils.setTargetOfEntity((LivingEntity)tyrosaur, (LivingEntity)entity);
                        new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_TYROSAUR_HURT).followEntity((Entity)tyrosaur).execute();
                    }
                }
                if (entity instanceof Player) {
                    Player pl = (Player)entity;
                    pl.getCooldowns().addCooldown((Item)this, 20);
                }
            }
            return stack;
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeUsed) {
        new SoundBuilder((Holder<SoundEvent>)AoASounds.ITEM_BONE_HORN_CALL).stopSound().execute();
    }

    public EntityType<TyrosaurEntity> getEntityType(ItemStack stack) {
        return stack.isDamaged() ? null : (EntityType)AoAMonsters.TYROSAUR.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (!stack.isDamaged()) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 2, new Component[0]));
        } else {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 5 - stack.getDamageValue(), new Component[0]));
        }
    }
}

