/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class SkillCrystal
extends Item {
    private final float denominator;
    private final int lowerLimit = 15;

    public SkillCrystal(float denominator) {
        this(denominator, Rarity.COMMON);
    }

    public SkillCrystal(float denominator, Rarity rarity) {
        super(new Item.Properties().rarity(rarity));
        this.denominator = denominator;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            PlayerUtil.getLowestSkillWithLimit(player, this.lowerLimit).ifPresentOrElse(skill -> {
                PlayerUtil.givePartialLevelToPlayer(pl, skill.type(), 1.0f / this.denominator, true);
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
            }, () -> PlayerUtil.notifyPlayer(player, (Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("item.skillCrystal.levelFail"), new Component[]{LocaleUtil.numToComponent(this.lowerLimit)})));
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.SKILL_CRYSTAL_DESCRIPTION, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.SKILL_CRYSTAL_SKILL_THRESHOLD, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)Integer.toString(15))}));
    }
}

