/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class Gravitator
extends Item {
    public Gravitator() {
        super(new Item.Properties().durability(1500));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            if (isSelected || pl.getOffhandItem() == stack) {
                if (entity.getDeltaMovement().y() < -0.079) {
                    entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, (double)0.8f, 1.0));
                    if (!level.isClientSide) {
                        if (RandomUtil.oneInNChance((int)15)) {
                            ItemUtil.damageItemForUser(pl, stack, EquipmentSlot.MAINHAND);
                        }
                        entity.fallDistance *= 0.8f;
                    }
                }
                if (pl instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pl;
                    if (WorldUtil.isWorld(level, AoADimensions.HAVEN) && !entity.onGround() && level.getGameTime() % 5L == 0L) {
                        if (serverPlayer.isCreative()) {
                            return;
                        }
                        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(entity.blockPosition().getX(), entity.blockPosition().getY(), entity.blockPosition().getZ());
                        InventoryUtil.findItem((Player)serverPlayer, AoAItems.BLANK_REALMSTONE).filter(realmstone -> {
                            int i = 0;
                            while ((double)i < entity.getY()) {
                                if (!level.isEmptyBlock((BlockPos)pos.set(pos.getX(), pos.getY() - i, pos.getZ()))) {
                                    return false;
                                }
                                ++i;
                            }
                            return true;
                        }).ifPresent(realmstone -> serverPlayer.getInventory().setItem(realmstone.leftInt(), AoAItems.LUNALUS_REALMSTONE.toStack()));
                    }
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

