/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.datacomponent.CompressedItemData;
import net.tslat.aoa3.library.object.Text;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public class CompressedItem
extends Item {
    public CompressedItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public Component getName(ItemStack stack) {
        if (!stack.has(AoADataComponents.COMPRESSED_ITEM_DATA)) {
            return super.getName(stack);
        }
        return Text.of("item.aoa3.compressed_item.name", ((CompressedItemData)stack.get((DataComponentType)AoADataComponents.COMPRESSED_ITEM_DATA.get())).compressedStack());
    }

    public static long getCompressedCount(int maxStackSize, int compressions) {
        return (long)maxStackSize * Math.round(Math.pow(9.0, compressions));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        int compressions;
        CompressedItemData data = stack.has(AoADataComponents.COMPRESSED_ITEM_DATA) ? (CompressedItemData)stack.get(AoADataComponents.COMPRESSED_ITEM_DATA) : null;
        int n = compressions = data != null ? data.compressions() : 0;
        if (compressions > 0) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.SPECIAL, 1, new Component[]{Component.literal((String)NumberUtil.floorAndAppendSuffix(CompressedItem.getCompressedCount(data.compressedStack().getMaxStackSize(), compressions), true))}));
        }
    }
}

