/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.item.AoAFood;
import net.tslat.aoa3.content.skill.hauling.HaulingSpawnPool;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;

public class ChumItem
extends Item {
    public ChumItem() {
        super(new Item.Properties().food(AoAFood.CHUM));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player pPlayer, InteractionHand hand) {
        pPlayer.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(hand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return super.getUseDuration(stack, user) + 3;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        block5: {
            block6: {
                if (!(level instanceof ServerLevel)) break block5;
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getUseDuration(stack, user) - timeLeft >= 5) break block5;
                Vec3 velocityVector = EntityUtil.getVelocityVectorForFacing((Entity)user).multiply(1.0, 1.5, 1.0);
                List<BlockPos> positions = WorldUtil.getBlocksWithinAABB((Level)serverLevel, user.getBoundingBox().move(velocityVector.x() * 3.0, velocityVector.y() * 3.0, velocityVector.z() * 3.0), (blockState, mutable) -> blockState.getFluidState().is(FluidTags.WATER) && blockState.getFluidState().getHeight((BlockGetter)level, (BlockPos)mutable) > 0.85f);
                if (!positions.isEmpty() && RandomUtil.oneInNChance((int)Math.max(100 / positions.size(), 1))) {
                    BlockPos pos = (BlockPos)RandomUtil.getRandomSelection(positions);
                    Entity fish = this.getFishEntity(user, (Level)serverLevel, pos);
                    fish.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                    serverLevel.addFreshEntity(fish);
                }
                TELParticlePacket packet = new TELParticlePacket();
                ItemParticleOption particleData = new ItemParticleOption((ParticleType)AoAParticleTypes.FLOATING_ITEM_FRAGMENT.get(), stack);
                for (float i = -0.15f; i <= 0.15f; i += 0.05f) {
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)particleData, (double)user.getX(), (double)(user.getY() + (double)user.getEyeHeight()), (double)user.getZ()).velocity(velocityVector.x() + (double)(i * 2.0f) * velocityVector.z(), velocityVector.y(), velocityVector.z() + (double)(i * 2.0f) * velocityVector.x()));
                }
                packet.sendToAllNearbyPlayers(serverLevel, user.position(), 32.0);
                if (!(user instanceof Player)) break block6;
                Player player = (Player)user;
                if (player.getAbilities().instabuild) break block5;
            }
            stack.shrink(1);
        }
    }

    private Entity getFishEntity(LivingEntity user, Level level, BlockPos pos) {
        int selection;
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            Optional<Entity> fish = HaulingSpawnPool.getPoolForLocation(level, pos, (FluidType)NeoForgeMod.WATER_TYPE.value()).map(pool -> pool.getEntry(player, player.getLuck())).filter(Optional::isPresent).map(Optional::get).filter(haulingEntity -> haulingEntity.object().right().isPresent()).map(haulingEntity -> haulingEntity.apply(level, false));
            if (fish.isPresent()) {
                return fish.get();
            }
        }
        if ((selection = RandomUtil.randomNumberUpTo((int)66)) == 0) {
            return new Dolphin(EntityType.DOLPHIN, level);
        }
        if (selection <= 5) {
            return new Squid(EntityType.SQUID, level);
        }
        if (selection <= 15) {
            return new Pufferfish(EntityType.PUFFERFISH, level);
        }
        if (selection <= 30) {
            return new Cod(EntityType.COD, level);
        }
        if (selection <= 45) {
            return new Salmon(EntityType.SALMON, level);
        }
        return new TropicalFish(EntityType.TROPICAL_FISH, level);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

