/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.lootbox;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.LootUtil;

public class TreasureBox
extends Item {
    public TreasureBox() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            InventoryUtil.giveItemsTo(pl, LootUtil.generateLoot(AdventOfAscension.id("items/treasure_box"), LootUtil.getGiftParameters(pl.serverLevel(), pl.position(), (Entity)pl)));
            if (!pl.isCreative()) {
                heldStack.shrink(1);
            }
            pl.inventoryMenu.broadcastChanges();
            return InteractionResultHolder.success((Object)heldStack);
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

