/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.food;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAFood;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class Rosidons
extends Item {
    public Rosidons() {
        super(new Item.Properties().food(AoAFood.ROSIDONS));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide) {
            int minY = Math.max(world.getMinBuildHeight(), (int)Math.floor(entity.getY()));
            int calculatedY = WorldUtil.getHighestSafeLocation(world, (int)Math.floor(entity.getX()), (int)Math.floor(entity.getZ()), false, minY);
            if (calculatedY <= minY) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer pl = (ServerPlayer)entity;
                    PlayerUtil.notifyPlayer((Player)pl, (Component)Component.translatable((String)LocaleUtil.createFeedbackLocaleKey("item.rosidons.noHeightFail")));
                }
                return super.finishUsingItem(stack, world, entity);
            }
            if (((EntityTeleportEvent)NeoForge.EVENT_BUS.post((Event)new EntityTeleportEvent((Entity)entity, entity.getX(), (double)calculatedY, entity.getZ()))).isCanceled()) {
                return stack;
            }
            if ((double)calculatedY - entity.getY() >= 350.0 && entity instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)entity;
                AdvancementUtil.grantCriterion(pl, AdventOfAscension.id("completionist/super_escape_rope"), "350_blocks");
            }
            world.gameEvent((Holder)GameEvent.TELEPORT, entity.position(), GameEvent.Context.of((Entity)entity));
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.teleportTo(entity.getX(), (double)calculatedY + 1.5, entity.getZ());
        }
        return super.finishUsingItem(stack, world, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

