/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.food;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoAFood;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class HeartFruit
extends Item {
    public HeartFruit() {
        super(new Item.Properties().food(AoAFood.HEART_FRUIT));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide) {
            ServerPlayer pl;
            DamageUtil.doRecoilAttack((Entity)entity, 7.0f);
            if (entity.getHealth() > 0.0f && WorldUtil.isWorld(level, AoADimensions.PRECASIA) && entity instanceof ServerPlayer && InventoryUtil.findItemForConsumption((Player)(pl = (ServerPlayer)entity), AoAItems.BLANK_REALMSTONE, 1, true)) {
                InventoryUtil.giveItemTo(pl, AoAItems.CANDYLAND_REALMSTONE);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

