/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.food;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAFood;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class Chilli
extends Item {
    public Chilli() {
        super(new Item.Properties().food(AoAFood.CHILLI));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide()) {
            entity.igniteForSeconds(3.0f);
            if (entity instanceof ServerPlayer && WorldUtil.isWorld(world, AoADimensions.NETHER) && entity.isInLava()) {
                AdvancementUtil.grantCriterion((ServerPlayer)entity, AdventOfAscension.id("nether/overheat"), "lava_chilli_consume");
            }
        }
        return super.finishUsingItem(stack, world, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 1, new Component[0]));
    }
}

