/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.datacomponent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;

public record GunStats(float damage, int ticksBetweenShots, float recoilModifier, float unholsterTimeModifier) {
    public static final Codec<GunStats> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("damage").forGetter(GunStats::damage), (App)Codec.INT.fieldOf("ticks_between_shots").forGetter(GunStats::ticksBetweenShots), (App)Codec.FLOAT.fieldOf("recoil_modifier").forGetter(GunStats::recoilModifier), (App)Codec.FLOAT.fieldOf("unholster_time_modifier").forGetter(GunStats::unholsterTimeModifier)).apply((Applicative)builder, GunStats::new));
    public static final StreamCodec<FriendlyByteBuf, GunStats> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, GunStats::damage, (StreamCodec)ByteBufCodecs.VAR_INT, GunStats::ticksBetweenShots, (StreamCodec)ByteBufCodecs.FLOAT, GunStats::recoilModifier, (StreamCodec)ByteBufCodecs.FLOAT, GunStats::unholsterTimeModifier, GunStats::new);

    public static float calculateDefaultUnholsterMod(boolean isThrownWeapon, float baseDamage, int ticksBetweenShots) {
        if (baseDamage <= 0.0f) {
            return 0.8f;
        }
        if (isThrownWeapon) {
            return 0.5f;
        }
        return 0.8f + 0.17f * Math.min(20.0f / (float)ticksBetweenShots * baseDamage / 55.0f, 0.85f);
    }

    public static Item.Properties of(float damage, int ticksBetweenShots, float recoilModifier, float unholsterTimeModifier) {
        return new Item.Properties().component((DataComponentType)AoADataComponents.GUN_STATS.get(), (Object)new GunStats(damage, ticksBetweenShots, recoilModifier, unholsterTimeModifier)).attributes(BaseGun.createGunAttributeModifiers(unholsterTimeModifier));
    }
}

