/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class SubterraneanArmour
extends AdventArmour {
    private static final AttributeModifier ATTACK_SPEED_DEBUFF = new AttributeModifier(AdventOfAscension.id("subterranean_armor_debuff"), -0.16666667, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public SubterraneanArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.SUBTERRANEAN, slot, 47);
    }

    @Override
    public void onEquip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (piece == AdventArmour.Piece.FULL_SET) {
            AttributeUtil.applyTransientModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, ATTACK_SPEED_DEBUFF);
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (piece == AdventArmour.Piece.FULL_SET) {
            AttributeUtil.removeModifier(entity, (Holder<Attribute>)Attributes.ATTACK_SPEED, ATTACK_SPEED_DEBUFF);
        }
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET)) {
            entity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 2, 1, true, false));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.subterranean_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

