/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class RunicArmour
extends AdventArmour {
    public RunicArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.RUNIC, slot, 67);
    }

    @Override
    public void handleIncomingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingIncomingDamageEvent ev) {
        if (DamageUtil.isMagicDamage(ev.getSource())) {
            ev.setAmount(ev.getAmount() * (1.0f - this.perPieceValue(equippedPieces, 0.1f)));
        }
    }

    @Override
    public void afterTakingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingDamageEvent.Post ev) {
        Player player;
        if (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET) && (!(entity instanceof Player) || !this.isOnCooldown(player = (Player)entity)) && DamageUtil.isMagicDamage(ev.getSource())) {
            entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 200, 0, false, false));
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                this.setArmourCooldown(player2, AoAArmour.RUNIC_ARMOUR, 6000);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.runic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.runic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.runic_armour.desc.3", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
    }
}

