/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RockboneArmour
extends AdventArmour {
    public RockboneArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.ROCKBONE, slot, 45);
    }

    @Override
    public void handleIncomingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingIncomingDamageEvent ev) {
        if (DamageUtil.isRangedDamage(ev.getSource())) {
            if (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET) && RandomUtil.oneInNChance((int)10)) {
                ev.setCanceled(true);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer pl = (ServerPlayer)entity;
                    for (ItemStack armour : pl.getArmorSlots()) {
                        if (EnchantmentUtil.getEnchantmentLevel(pl.level(), armour, (ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION) >= 4) continue;
                        return;
                    }
                    AdvancementUtil.grantCriterion(pl, AdventOfAscension.id("completionist/reverse_stormtrooper"), "max_dodge");
                }
                return;
            }
            ev.setAmount(ev.getAmount() * (1.0f - this.perPieceValue(equippedPieces, 0.1f)));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.rockbone_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.rockbone_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

