/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import org.apache.commons.lang3.mutable.MutableInt;

public class NecroArmour
extends AdventArmour {
    public NecroArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.NECRO, slot, 64);
    }

    @Override
    public void beforeTakingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingDamageEvent.Pre ev) {
        Player pl;
        if (!(!equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET) || DamageUtil.isEnvironmentalDamage(ev.getContainer().getSource()) || !(ev.getContainer().getNewDamage() >= entity.getHealth()) || entity instanceof Player && this.isOnCooldown(pl = (Player)entity))) {
            ev.getContainer().setNewDamage(0.0f);
            entity.hurtArmor(entity.level().damageSources().generic(), 2000.0f);
            if (entity.getHealth() < 4.0f) {
                entity.setHealth(4.0f);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer pl2 = (ServerPlayer)entity;
                this.setArmourCooldown((Player)pl2, AoAArmour.NECRO_ARMOUR, 72000);
            }
            ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.HEART, (Entity)entity).spawnNTimes(5).sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingDeathEvent ev) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer pl = (ServerPlayer)entity;
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
        Level level = pl.level();
        MutableInt count = new MutableInt(this.perPieceValue(equippedPieces, 1));
        if (count.intValue() > 0) {
            plData.storage.putItemsInStorage(stack -> {
                if (!EnchantmentUtil.hasEnchantment(level, stack, AoAEnchantments.INTERVENTION) && !EnchantmentUtil.hasEnchantment(level, stack, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE)) {
                    count.decrement();
                    return true;
                }
                return false;
            }, () -> count.intValue() > 0);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.4", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

