/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.resource.SpiritResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class EmbrodiumArmour
extends AdventArmour {
    public EmbrodiumArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.EMBRODIUM, slot, 45);
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (entity instanceof ServerPlayer) {
            float f;
            ServerPlayer player = (ServerPlayer)entity;
            AoAResource.Instance instance = PlayerUtil.getAdventPlayer(player).getResource((AoAResource)AoAResources.SPIRIT.get());
            if (instance instanceof SpiritResource) {
                SpiritResource spirit = (SpiritResource)instance;
                f = spirit.getPerTickRegen();
            } else {
                f = 0.04f;
            }
            float perTickRegen = f;
            float amount = equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET) ? perTickRegen * 0.25f : 0.0f;
            float temp = WorldUtil.getAmbientTemperature(player.level(), player.blockPosition());
            if (temp > 0.8f) {
                amount += this.perPieceValue(equippedPieces, perTickRegen * 0.25f) * Math.min(1.0f, temp / 2.0f);
            }
            if (amount > 0.0f) {
                PlayerUtil.addResourceToPlayer(player, (AoAResource)AoAResources.SPIRIT.get(), amount);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.embrodium_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.embrodium_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

