/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class ElecanyteArmour
extends AdventArmour {
    public ElecanyteArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.ELECANYTE, slot, 63);
    }

    @Override
    public void afterTakingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingDamageEvent.Post ev) {
        if (ev.getNewDamage() > 0.0f && entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            if (!DamageUtil.isEnvironmentalDamage(ev.getSource())) {
                PlayerUtil.addResourceToPlayer(pl, (AoAResource)AoAResources.SPIRIT.get(), ev.getNewDamage() * this.perPieceValue(equippedPieces, 2.5f));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.elecanyte_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.elecanyte_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

