/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class CandyArmour
extends AdventArmour {
    public CandyArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.CANDY, slot, 59);
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        ServerPlayer pl;
        if (entity instanceof ServerPlayer && (pl = (ServerPlayer)entity).getFoodData().needsFood() && (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET) || !this.isOnCooldown((Player)pl)) && this.findAndConsumeFood((Player)pl)) {
            this.setArmourCooldown((Player)pl, AoAArmour.CANDY_ARMOUR, 12000 / this.perPieceValue(equippedPieces, 1));
        }
    }

    private boolean findAndConsumeFood(Player player) {
        return InventoryUtil.findItem(player, stack -> {
            FoodProperties properties = stack.getFoodProperties((LivingEntity)player);
            return properties != null && properties.nutrition() > 0 && properties.saturation() > 0.0f;
        }).map(pair -> {
            player.getInventory().setItem(pair.leftInt(), ((ItemStack)pair.right()).getItem().finishUsingItem((ItemStack)pair.right(), player.level(), (LivingEntity)player));
            return true;
        }).orElse(false);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.candy_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

