/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class BoreicArmour
extends AdventArmour {
    public BoreicArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.BOREIC, slot, 62);
    }

    @Override
    public void afterTakingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingDamageEvent.Post ev) {
        if (ev.getNewDamage() > 0.0f && entity.isInWater() && !DamageUtil.isEnvironmentalDamage(ev.getSource())) {
            WorldUtil.createExplosion((Entity)entity, entity.level(), entity.blockPosition(), 0.7f + this.perPieceValue(equippedPieces, 0.3f));
            if (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET)) {
                for (LivingEntity entity22 : EntityRetrievalUtil.getEntities((Entity)entity, (double)4.0, entity2 -> entity2 instanceof LivingEntity && EntityUtil.isHostileMob(entity2))) {
                    entity22.addEffect(new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 40).level(2).isAmbient().build());
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.boreic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.boreic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.boreic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

