/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class BiogenicArmour
extends AdventArmour {
    public BiogenicArmour(ArmorItem.Type slot) {
        super((Holder<ArmorMaterial>)AoAArmourMaterials.BIOGENIC, slot, 38);
    }

    @Override
    public void onArmourTick(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces) {
        if (equippedPieces.contains((Object)AdventArmour.Piece.FULL_SET)) {
            if (entity.isInWater()) {
                entity.setAirSupply(-10);
            }
            if (entity.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
                entity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0, true, false));
            } else {
                MobEffectInstance nightVision = entity.getEffect(MobEffects.NIGHT_VISION);
                if (nightVision != null && nightVision.getDuration() <= 300) {
                    entity.removeEffect(MobEffects.NIGHT_VISION);
                }
            }
        }
    }

    @Override
    public void afterTakingDamage(LivingEntity entity, EnumSet<AdventArmour.Piece> equippedPieces, LivingDamageEvent.Post ev) {
        Entity entity2;
        if (ev.getNewDamage() > 0.0f && DamageUtil.isMeleeDamage(ev.getSource()) && (entity2 = ev.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            attacker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, Mth.ceil((float)(ev.getNewDamage() * (float)this.perPieceValue(equippedPieces, 3))), equippedPieces.size() >= 2 ? 1 : 0, false, true));
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, AdventArmour.Piece piece, EnumSet<AdventArmour.Piece> equippedPieces) {
        MobEffectInstance nightVision;
        if (piece == AdventArmour.Piece.FULL_SET && (nightVision = entity.getEffect(MobEffects.NIGHT_VISION)) != null && nightVision.getDuration() <= 300) {
            entity.removeEffect(MobEffects.NIGHT_VISION);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

