/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import com.google.common.base.Suppliers;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AdventArmour
extends ArmorItem {
    public AdventArmour(Holder<ArmorMaterial> material, ArmorItem.Type slot, int baseDurability) {
        this(material, slot, new Item.Properties().durability(slot.getDurability(baseDurability)));
    }

    public AdventArmour(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
        this.defaultModifiers = this.createAttributes((Holder<ArmorMaterial>)this.getMaterial(), this.getType());
    }

    private Supplier<ItemAttributeModifiers> createAttributes(Holder<ArmorMaterial> material, ArmorItem.Type slot) {
        return Suppliers.memoize(() -> {
            int armourValue = ((ArmorMaterial)material.value()).getDefense(slot);
            float toughness = ((ArmorMaterial)material.value()).toughness();
            float knockbackResistance = ((ArmorMaterial)material.value()).knockbackResistance();
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            EquipmentSlotGroup slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)slot.getSlot());
            ResourceLocation attributeId = ResourceLocation.withDefaultNamespace((String)("armor." + slot.getName()));
            builder.add(Attributes.ARMOR, new AttributeModifier(attributeId, (double)armourValue, AttributeModifier.Operation.ADD_VALUE), slotGroup);
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(attributeId, (double)toughness, AttributeModifier.Operation.ADD_VALUE), slotGroup);
            this.addArmourAttributes(slotGroup, (attribute, modifier) -> builder.add(attribute, modifier, slotGroup));
            if (knockbackResistance > 0.0f) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(attributeId, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), slotGroup);
            }
            return builder.build();
        });
    }

    public boolean isCompatibleWithAnySet() {
        return false;
    }

    public void addArmourAttributes(EquipmentSlotGroup slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributes) {
    }

    public void onEquip(LivingEntity entity, Piece piece, EnumSet<Piece> equippedPieces) {
    }

    public void onUnequip(LivingEntity entity, Piece piece, EnumSet<Piece> equippedPieces) {
    }

    public void onArmourTick(LivingEntity entity, EnumSet<Piece> equippedPieces) {
    }

    public void checkDamageInvulnerability(LivingEntity entity, EnumSet<Piece> equippedPieces, EntityInvulnerabilityCheckEvent ev) {
    }

    public void handleIncomingDamage(LivingEntity entity, EnumSet<Piece> equippedPieces, LivingIncomingDamageEvent ev) {
    }

    public void handleOutgoingAttack(LivingEntity entity, EnumSet<Piece> equippedPieces, LivingIncomingDamageEvent ev) {
    }

    public void beforeTakingDamage(LivingEntity entity, EnumSet<Piece> equippedPieces, LivingDamageEvent.Pre ev) {
    }

    public void afterTakingDamage(LivingEntity entity, EnumSet<Piece> equippedPieces, LivingDamageEvent.Post ev) {
    }

    public void afterOutgoingAttack(LivingEntity entity, EnumSet<Piece> equippedPieces, LivingDamageEvent.Post ev) {
    }

    public void onEntityDeath(LivingEntity entity, EnumSet<Piece> equippedPieces, LivingDeathEvent ev) {
    }

    public void onEffectApplication(LivingEntity entity, EnumSet<Piece> equippedPieces, MobEffectEvent.Applicable ev) {
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    protected MutableComponent setEffectHeader() {
        return LocaleUtil.getLocaleMessage(LocaleUtil.Keys.ARMOUR_SET_HEADER, ChatFormatting.GOLD, new Component[0]);
    }

    protected MutableComponent pieceEffectHeader() {
        return LocaleUtil.getLocaleMessage(LocaleUtil.Keys.ARMOUR_PIECE_HEADER, ChatFormatting.GRAY, new Component[0]);
    }

    protected MutableComponent anySetEffectHeader() {
        return LocaleUtil.getLocaleMessage(LocaleUtil.Keys.ARMOUR_ANY_SET_HEADER, ChatFormatting.DARK_AQUA, new Component[0]);
    }

    public boolean isHelmetAirTight(Player player) {
        return player.getItemBySlot(EquipmentSlot.HEAD).is(AoATags.Items.AIRTIGHT);
    }

    public void setArmourCooldown(Player player, AoAArmour.ArmourSet armourSet, int ticks) {
        ItemCooldowns cooldowns = player.getCooldowns();
        armourSet.forEach(item -> cooldowns.addCooldown(item, ticks));
    }

    public boolean isOnCooldown(Player player) {
        return this.getArmourCooldown(player) > 0;
    }

    public int getArmourCooldown(Player player) {
        ItemCooldowns cooldowns = player.getCooldowns();
        ItemCooldowns.CooldownInstance cooldown = (ItemCooldowns.CooldownInstance)cooldowns.cooldowns.get((Object)this);
        if (cooldown == null) {
            return 0;
        }
        return cooldown.endTime - cooldowns.tickCount;
    }

    public int perPieceValue(EnumSet<Piece> equippedPieces, int perPiece) {
        return perPiece * (equippedPieces.size() - (equippedPieces.contains((Object)Piece.FULL_SET) ? 1 : 0));
    }

    public float perPieceValue(EnumSet<Piece> equippedPieces, float perPiece) {
        return perPiece * (float)(equippedPieces.size() - (equippedPieces.contains((Object)Piece.FULL_SET) ? 1 : 0));
    }

    public static enum Piece {
        BOOTS,
        LEGGINGS,
        CHESTPLATE,
        HELMET,
        FULL_SET;


        public static Piece fromVanillaSlot(EquipmentSlot slot) {
            return switch (slot) {
                default -> throw new MatchException(null, null);
                case EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND -> throw new IllegalArgumentException("Attempted to convert non-armour vanilla slot to AoA armour slot?");
                case EquipmentSlot.HEAD -> HELMET;
                case EquipmentSlot.CHEST, EquipmentSlot.BODY -> CHESTPLATE;
                case EquipmentSlot.LEGS -> LEGGINGS;
                case EquipmentSlot.FEET -> BOOTS;
            };
        }

        @Nullable
        public EquipmentSlot toVanillaSlot() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 3 -> EquipmentSlot.HEAD;
                case 2 -> EquipmentSlot.CHEST;
                case 1 -> EquipmentSlot.LEGS;
                case 0 -> EquipmentSlot.FEET;
                case 4 -> null;
            };
        }
    }
}

