/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item;

import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public interface EnergyProjectileWeapon {
    public InteractionHand getWeaponHand(LivingEntity var1);

    public void doBlockImpact(BaseEnergyShot var1, Vec3 var2, LivingEntity var3);

    public boolean doEntityImpact(BaseEnergyShot var1, Entity var2, LivingEntity var3);

    default public boolean doEntityImpact(ServerLevel level, LivingEntity shooter, ItemStack stack, ShotInfo shotInfo, EntityHitResult rayTrace) {
        return true;
    }

    default public boolean doBlockImpact(ServerLevel level, LivingEntity shooter, ItemStack stack, ShotInfo shotInfo, BlockHitResult rayTrace) {
        return true;
    }

    default public ShotInfo getPosAndRotForShot(EnergyProjectileWeapon weapon, LivingEntity shooter, float inaccuracy, float beamDistance) {
        RandomSource random = shooter.getRandom();
        boolean rightSide = shooter.getMainArm() == HumanoidArm.RIGHT ? weapon.getWeaponHand(shooter) == InteractionHand.MAIN_HAND : weapon.getWeaponHand(shooter) == InteractionHand.OFF_HAND;
        Vec3 shooterAngle = shooter.getLookAngle();
        float yaw = (float)Mth.atan2((double)shooterAngle.x, (double)shooterAngle.z);
        float armDist = this.getDistToBlasterArm(weapon, shooter);
        float xOffset = Mth.cos((float)yaw) * armDist;
        float zOffset = Mth.sin((float)yaw) * armDist;
        Vec3 rayStart = shooter.getEyePosition().add((double)(xOffset * (float)(rightSide ? -1 : 1)), (double)this.getBlasterHeightOffset(weapon, shooter), (double)(zOffset * (float)(rightSide ? 1 : -1)));
        Vec3 angle = rayStart.vectorTo(shooter.getEyePosition().add(shooterAngle.scale((double)beamDistance))).normalize().add(random.triangle(0.0, 0.0172275 * (double)inaccuracy), random.triangle(0.0, 0.0172275 * (double)inaccuracy), random.triangle(0.0, 0.0172275 * (double)inaccuracy));
        return new ShotInfo(rayStart, rayStart.add(angle.scale((double)this.getChamberLength(weapon, shooter))), angle);
    }

    default public float getChamberLength(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return 1.5f;
    }

    default public float getDistToBlasterArm(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return 0.4f;
    }

    default public float getBlasterHeightOffset(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return -0.2f;
    }

    public record ShotInfo(Vec3 position, Vec3 barrelPos, Vec3 angle, MutableObject<Vec3> hitPos, MutableBoolean effectiveHit) {
        public ShotInfo(Vec3 position, Vec3 barrelPos, Vec3 angle) {
            this(position, barrelPos, angle, (MutableObject<Vec3>)new MutableObject(), new MutableBoolean(false));
        }

        public float getPitch() {
            return (float)Mth.atan2((double)this.angle.y, (double)this.angle.horizontalDistance()) * 57.295776f;
        }

        public float getYaw() {
            return (float)Mth.atan2((double)this.angle.x, (double)this.angle.z) * 57.295776f;
        }

        public Vec3 shotOrBarrelPosForVfx() {
            return this.getHitPos().map(hitPos -> this.position().distanceToSqr(hitPos) < this.position().distanceToSqr(this.barrelPos) ? this.position() : this.barrelPos()).orElse(this.position);
        }

        public Optional<Vec3> getHitPos() {
            return Optional.ofNullable((Vec3)this.hitPos.getValue());
        }

        public boolean wasEffectiveHit() {
            return this.effectiveHit.getValue();
        }

        public void setEffectiveHit(boolean effective) {
            this.effectiveHit.setValue(effective);
        }

        public void setHitPos(Vec3 hitPos) {
            this.hitPos.setValue((Object)hitPos);
        }
    }
}

