/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.staff;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEnergyShot
extends ThrowableProjectile {
    protected int lifespan;
    private int age = 0;
    protected EnergyProjectileWeapon weapon;
    private Entity cachedOwner = null;

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(entityType, shooter.level());
        this.lifespan = 60;
        this.weapon = weapon;
        this.setOwner((Entity)shooter);
        this.moveTo(posX, posY, posZ, 0.0f, 360.0f);
        this.setDeltaMovement(new Vec3(motionX, motionY, motionZ));
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, Entity shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, float velocity) {
        super(entityType, shooter.level());
        this.lifespan = 120;
        this.weapon = weapon;
        this.setOwner(shooter);
        this.moveTo(posX, posY, posZ, 0.0f, 360.0f);
        this.setDeltaMovement(new Vec3(this.random.nextGaussian() / 33.0 + 0.03, (double)(-velocity), this.random.nextGaussian() / 33.0 + 0.03));
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge, float xMod, float yMod, float zMod) {
        super(entityType, shooter.level());
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.setOwner((Entity)shooter);
        this.moveTo(shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight(), shooter.getZ(), shooter.getYRot(), shooter.getXRot());
        boolean right = true;
        if (shooter instanceof Player) {
            if (weapon.getWeaponHand(shooter) == InteractionHand.MAIN_HAND) {
                if (shooter.getMainArm() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.getMainArm() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.shoot((double)(-Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI))) + (double)xMod, (double)(-Mth.sin((float)(this.getXRot() / 180.0f * (float)Math.PI))) + (double)yMod, (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI))) + (double)zMod, 3.0f, 1.0f);
        if (right) {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() - (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() + (double)(Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() + (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() - (double)(Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super(entityType, shooter.level());
        boolean right;
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.setOwner((Entity)shooter);
        this.moveTo(shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight(), shooter.getZ(), shooter.getYRot(), shooter.getXRot());
        boolean bl = right = shooter.getMainArm() == HumanoidArm.RIGHT;
        if (shooter instanceof Player) {
            if (weapon.getWeaponHand(shooter) == InteractionHand.MAIN_HAND) {
                if (shooter.getMainArm() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.getMainArm() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.shoot(-Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI)), -Mth.sin((float)(this.getXRot() / 180.0f * (float)Math.PI)), Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI)), 3.0f, 1.0f);
        if (right) {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() - (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() + (double)(Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.setPos(this.getDeltaMovement().x() * 0.5 + this.getX() + (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f), this.getDeltaMovement().y() * 0.5 + this.getY() - 0.3, this.getDeltaMovement().z() * 0.5 + this.getZ() - (double)(Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseEnergyShot(EntityType<? extends ThrowableProjectile> entityType, Level world, double x, double y, double z) {
        super(entityType, world);
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && this.cachedOwner.isAlive()) {
            return this.cachedOwner;
        }
        this.cachedOwner = super.getOwner();
        return this.cachedOwner;
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            Entity shooter;
            if (this.weapon != null && this.isAlive() && (shooter = this.getOwner()) instanceof LivingEntity) {
                if (result.getType() == HitResult.Type.BLOCK) {
                    this.weapon.doBlockImpact(this, result.getLocation(), (LivingEntity)shooter);
                } else if (result.getType() == HitResult.Type.ENTITY) {
                    this.weapon.doEntityImpact(this, ((EntityHitResult)result).getEntity(), (LivingEntity)shooter);
                }
            }
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void tick() {
        if (!this.isAlive()) {
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        Vec3 position = new Vec3(this.getX() - motion.x() * 0.5, this.getY() - motion.y() * 0.5, this.getZ() - motion.z() * 0.5);
        Vec3 velocityAdjustedPosition = new Vec3(this.getX() + motion.x(), this.getY() + motion.y(), this.getZ() + motion.z());
        BlockHitResult collisionTrace = this.level().clip(new ClipContext(position, velocityAdjustedPosition, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, CollisionContext.empty()));
        velocityAdjustedPosition = collisionTrace.getType() != HitResult.Type.MISS ? new Vec3(collisionTrace.getLocation().x, collisionTrace.getLocation().y, collisionTrace.getLocation().z) : new Vec3(this.getX() + motion.x(), this.getY() + motion.y(), this.getZ() + motion.z());
        Entity shooter = this.getOwner();
        EntityHitResult entityTrace = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)position, (Vec3)velocityAdjustedPosition, (AABB)this.getBoundingBox().expandTowards(motion.x(), motion.y(), motion.z()).inflate(0.5), entity -> entity.isAlive() && entity.isPickable() && !entity.isSpectator() && entity != shooter);
        if (entityTrace != null) {
            collisionTrace = entityTrace;
        }
        if (collisionTrace.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)collisionTrace)) {
            this.onHit((HitResult)collisionTrace);
        }
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        super.tick();
        if (!this.level().isClientSide) {
            if (this.age > this.lifespan) {
                this.discard();
            } else {
                ++this.age;
            }
        }
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public int getAge() {
        return this.age;
    }
}

