/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.monster.overworld.TreeSpiritEntity;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.EntityUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TreeSpiritSpriteEntity
extends BaseMobProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Entity target;

    public TreeSpiritSpriteEntity(EntityType<? extends TreeSpiritSpriteEntity> entityType, Level level) {
        super(entityType, level);
        this.target = null;
    }

    public TreeSpiritSpriteEntity(TreeSpiritEntity treeSpirit, Entity target) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.TREE_SPIRIT_SPRITE.get()), treeSpirit.level());
        this.projectileType = BaseMobProjectile.Type.MAGIC;
        this.shooter = treeSpirit;
        this.target = target;
        this.moveTo(treeSpirit.getX(), treeSpirit.getEyeY(), treeSpirit.getZ());
        this.setDeltaMovement(0.0, 0.5, 0.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.target == null || this.target.level() != this.level() || !this.target.isAlive() || this.level().getDifficulty() == Difficulty.PEACEFUL) {
                this.kill();
                return;
            }
            this.setDeltaMovement(EntityUtil.getEntityCenter(this.target).subtract(EntityUtil.getEntityCenter((Entity)this)).normalize().scale(0.3).vectorTo(this.getDeltaMovement()).scale(0.2).vectorTo(this.getDeltaMovement()));
        } else if (this.tickCount % 4 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.isInvulnerableTo(source)) {
            this.markHurt();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SLIME_JUMP, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, this.getRandomX(0.5), this.getY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            this.kill();
            return true;
        }
        return false;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Living", 0, state -> state.setAndContinue(DefaultAnimations.LIVING)));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

