/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FireballEntity
extends BaseMobProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FireballEntity(EntityType<? extends FireballEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FireballEntity(Level world, AoARangedAttacker shooter, BaseMobProjectile.Type projectileType) {
        this((EntityType<? extends FireballEntity>)((EntityType)AoAProjectiles.FIREBALL.get()), world, shooter, projectileType);
    }

    public FireballEntity(EntityType<? extends FireballEntity> entityType, Level world, AoARangedAttacker shooter, BaseMobProjectile.Type projectileType) {
        super(entityType, world, shooter, projectileType);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Living", 0, state -> state.setAndContinue(DefaultAnimations.LIVING)));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide() && (this.getDeltaMovement().lengthSqr() != 0.0 || this.tickCount % 4 == 0)) {
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(0.5), this.getY(0.5), this.getZ(0.5), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.25), this.getRandomY(), this.getRandomZ(0.25), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.25), this.getRandomY(), this.getRandomZ(0.25), 0.0, 0.0, 0.0);
        } else if (this.tickCount > 100) {
            this.discard();
        }
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

