/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseMobProjectile
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected Type projectileType;
    protected AoARangedAttacker shooter;

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, double posX, double posY, double posZ, Type projectileType) {
        super(entityType, world);
        this.setPos(posX, posY, posZ);
        this.setDeltaMovement(this.random.nextGaussian() / 33.0 + 0.03, -2.0, this.random.nextGaussian() / 33.0 + 0.03);
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, Entity target, Type projectileType) {
        this(entityType, world, shooter, target.getX(), target.getY() + 25.0, target.getZ(), projectileType);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, Type projectileType) {
        super(entityType, world);
        if (shooter instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)shooter;
            this.setOwner((Entity)owner);
            this.setPos(owner.getX(), owner.getY() + (double)owner.getEyeHeight() - (double)0.1f, owner.getZ());
        }
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public Type getProjectileType() {
        return this.projectileType;
    }

    public double getDefaultGravity() {
        return 0.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 500) {
            this.discard();
        }
    }

    protected void onHit(HitResult result) {
        if ((result.getType() != HitResult.Type.BLOCK || this.level().getBlockState(BlockPos.containing((Position)result.getLocation())).blocksMotion()) && !this.level().isClientSide) {
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (entityHitResult.getEntity() == this.shooter || this.shooter == null) {
                    return;
                }
                this.onHitEntity(entityHitResult);
                this.shooter.doRangedAttackEntity(this, entityHitResult.getEntity());
            } else if (result instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                if (this.shooter != null) {
                    this.onHitBlock(blockHitResult);
                    this.shooter.doRangedAttackBlock(this, this.level().getBlockState(BlockPos.containing((Position)result.getLocation())), BlockPos.containing((Position)result.getLocation()), blockHitResult.getDirection());
                }
            }
            this.discard();
        }
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(DefaultAnimations.genericLivingController((GeoAnimatable)this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public static enum Type {
        MAGIC,
        PHYSICAL,
        GUN,
        ENERGY;

    }
}

