/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.misc;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;

public class TidalWaveEntity
extends ThrowableProjectile {
    public TidalWaveEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public TidalWaveEntity(Level world) {
        super((EntityType)AoAProjectiles.TIDAL_WAVE.get(), world);
    }

    public TidalWaveEntity(Level world, LivingEntity shooter, double xOffset, double zOffset) {
        super((EntityType)AoAProjectiles.TIDAL_WAVE.get(), shooter, world);
        this.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 1.5f, 0.05f);
        this.setPos(this.getX() + xOffset, this.getY(), this.getZ() + zOffset);
    }

    public double getDefaultGravity() {
        return this.tickCount / 3 % 2 == 0 ? (double)-0.1f : (double)0.1f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.tickCount > 20) {
            this.discard();
            return;
        }
        super.tick();
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            Entity entity;
            EntityHitResult rayTraceResult;
            if (result.getType() == HitResult.Type.BLOCK) {
                this.discard();
            } else if (result.getType() == HitResult.Type.ENTITY && (rayTraceResult = (EntityHitResult)result).getEntity() != this.getOwner() && (entity = EntityUtil.getPartOrPartOwner(rayTraceResult.getEntity())) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                DamageUtil.doBodySlamKnockback(target, (Entity)this, 0.3f, 0.3f, 0.3f);
            }
        }
    }
}

