/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.misc;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.WorldUtil;

public class ErebonSticklerStuckEntity
extends ThrowableProjectile {
    private LivingEntity target;
    private LivingEntity shooter;
    private int age;
    private AreaEffectCloud cloud = null;

    public ErebonSticklerStuckEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public ErebonSticklerStuckEntity(Level world) {
        super((EntityType)AoAProjectiles.EREBON_STICKLER_STUCK.get(), world);
    }

    public ErebonSticklerStuckEntity(LivingEntity shooter, BaseGun gun, LivingEntity target, float bulletDmgMultiplier) {
        super((EntityType)AoAProjectiles.EREBON_STICKLER_STUCK.get(), shooter.level());
        this.target = target;
        this.shooter = shooter;
        this.moveTo(target.getX(), target.getY() + (double)target.getEyeHeight(), target.getZ(), 0.0f, 0.0f);
        this.shoot(0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    public ErebonSticklerStuckEntity(Level world, double x, double y, double z) {
        super((EntityType)AoAProjectiles.EREBON_STICKLER_STUCK.get(), x, y, z, world);
    }

    public double getDefaultGravity() {
        return 0.0;
    }

    protected void onHit(HitResult result) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        ++this.age;
        if (this.target == null || !this.target.isAlive()) {
            WorldUtil.createExplosion((Entity)this.shooter, this.level(), (Entity)this, 2.0f);
            this.discard();
            if (this.cloud != null) {
                this.cloud.discard();
            }
            return;
        }
        this.moveTo(this.target.getX(), this.target.getY() + (double)this.target.getEyeHeight(), this.target.getZ(), 0.0f, 360.0f);
        if (this.age >= 100) {
            WorldUtil.createExplosion(this.getOwner(), this.level(), this.getX(), this.getY() + 1.0, this.getZ(), 2.0f);
            this.discard();
            if (this.cloud != null) {
                this.cloud.discard();
            }
            return;
        }
        if (this.cloud == null) {
            this.cloud = new AreaEffectCloud(this.level(), this.target.getX(), this.target.getY(), this.target.getZ());
            this.cloud.setDuration(100 - this.age);
            this.cloud.setRadius(2.0f);
            this.cloud.addEffect(new MobEffectInstance(MobEffects.WITHER, 40, 0, false, true));
            this.level().addFreshEntity((Entity)this.cloud);
        } else {
            this.cloud.teleportTo(this.target.getX(), this.target.getY(), this.target.getZ());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

