/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.cannon;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.WorldUtil;

public class StickyRedBombEntity
extends BaseBullet
implements HardProjectile {
    private BaseGun weapon;
    private LivingEntity shooter;
    private int ticksInGround = 0;

    public StickyRedBombEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public StickyRedBombEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STICKY_RED_BOMB.get()), world);
    }

    public StickyRedBombEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STICKY_RED_BOMB.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
        this.weapon = gun;
        this.shooter = shooter;
    }

    public StickyRedBombEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STICKY_RED_BOMB.get()), world, x, y, z);
    }

    @Override
    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.BLOCK) {
            BlockHitResult rayTraceResult = (BlockHitResult)result;
            BlockState bl = this.level().getBlockState(rayTraceResult.getBlockPos());
            double posX = rayTraceResult.getBlockPos().getX();
            double posY = rayTraceResult.getBlockPos().getY();
            double posZ = rayTraceResult.getBlockPos().getZ();
            if (!bl.blocksMotion()) {
                return;
            }
            ++this.ticksInGround;
            this.setDeltaMovement(0.0, 0.0, 0.0);
            switch (rayTraceResult.getDirection()) {
                case UP: {
                    posY += 1.0;
                    break;
                }
                case DOWN: {
                    posY -= 1.0;
                    break;
                }
                case SOUTH: {
                    posZ += 0.5;
                    break;
                }
                case NORTH: {
                    posZ -= 0.5;
                    break;
                }
                case EAST: {
                    posX += 0.5;
                    break;
                }
                case WEST: {
                    posX -= 0.5;
                    break;
                }
            }
            this.setPos(posX, posY, posZ);
        } else if (!this.level().isClientSide()) {
            if (result instanceof EntityHitResult) {
                EntityHitResult entityResult = (EntityHitResult)result;
                Entity shooter = this.getOwner();
                if (shooter instanceof LivingEntity) {
                    this.weapon.doImpactDamage(entityResult.getEntity(), (LivingEntity)shooter, this, result.getLocation(), 1.0f);
                }
                this.doEntityImpact(entityResult.getEntity(), entityResult.getLocation());
            }
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksInGround > 0) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            ++this.ticksInGround;
            if (this.ticksInGround >= 80 && !this.level().isClientSide) {
                this.explode(this.position());
                return;
            }
            if (!this.level().isClientSide) {
                this.unsetRemoved();
            }
        }
    }

    @Override
    public void doBlockImpact(Vec3 impactLocation, Direction face, BlockPos blockPos) {
        this.explode(impactLocation);
    }

    @Override
    public void doEntityImpact(Entity target, Vec3 impactLocation) {
        this.explode(impactLocation);
    }

    protected void explode(Vec3 position) {
        WorldUtil.createExplosion(this.getOwner(), this.level(), (Entity)this, 2.0f);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }
}

