/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.cannon;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;

public class RockFragmentEntity
extends BaseBullet
implements HardProjectile {
    public RockFragmentEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public RockFragmentEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ROCK_FRAGMENT.get()), world);
    }

    public RockFragmentEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ROCK_FRAGMENT.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public RockFragmentEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ROCK_FRAGMENT.get()), world, x, y, z);
    }

    @Override
    public void doBlockImpact(Vec3 impactLocation, Direction face, BlockPos blockPos) {
        if (!this.level().isClientSide && AoAGameRules.checkDestructiveWeaponPhysics(this.level()) && this.level().isEmptyBlock(this.blockPosition())) {
            int i = 1;
            while (this.level().getBlockState(this.blockPosition().below(i)).canBeReplaced() && this.blockPosition().getY() - i >= 0) {
                ++i;
            }
            if (this.blockPosition().getY() - i <= 0) {
                return;
            }
            this.level().setBlockAndUpdate(this.blockPosition().below(i - 1), Blocks.COBBLESTONE.defaultBlockState());
        }
    }

    @Override
    public double getDefaultGravity() {
        return 0.06f;
    }
}

