/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.blaster;

import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.util.EntityUtil;

public class HellBubbleShotEntity
extends BaseEnergyShot {
    public HellBubbleShotEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public HellBubbleShotEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELL_BUBBLE_SHOT.get()), world);
    }

    public HellBubbleShotEntity(LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELL_BUBBLE_SHOT.get()), shooter, weapon, maxAge);
    }

    public HellBubbleShotEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELL_BUBBLE_SHOT.get()), world, x, y, z);
    }

    @Override
    public void tick() {
        List collidingEntities;
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.3, 0.3));
        if (this.getAge() >= 100) {
            this.discard();
        }
        if (!this.isAlive()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.BUBBLE_SHOT_POP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (!this.level().isClientSide && this.weapon != null && !(collidingEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), EntityUtil::isHostileMob)).isEmpty()) {
            Entity shooter = this.getOwner();
            if (shooter instanceof LivingEntity) {
                this.weapon.doEntityImpact(this, (Entity)collidingEntities.get(0), (LivingEntity)shooter);
            }
            this.discard();
        }
    }
}

