/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.blaster;

import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.util.LocaleUtil;

public class ArcwormShotEntity
extends BaseEnergyShot {
    public ArcwormShotEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public ArcwormShotEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ARCWORM_SHOT.get()), world);
    }

    public ArcwormShotEntity(LivingEntity shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ARCWORM_SHOT.get()), shooter, weapon, maxAge);
    }

    public ArcwormShotEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.ARCWORM_SHOT.get()), world, x, y, z);
    }

    @Override
    public double getDefaultGravity() {
        return 0.1f;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        double motionVector = Math.sqrt(motion.x() * motion.x() + motion.z() * motion.z());
        this.setYRot((float)(Mth.atan2((double)motion.x(), (double)motion.z()) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)motion.y(), (double)motionVector) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public Component getName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return LocaleUtil.getLocaleMessage("entity.aoa3.arcworm");
    }
}

