/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.arrow;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.item.ArrowFiringWeapon;
import org.jetbrains.annotations.Nullable;

public class CustomArrowEntity
extends Arrow {
    private boolean ignoreExplosions = false;

    public CustomArrowEntity(EntityType<? extends Arrow> type, Level world) {
        super(type, world);
    }

    public CustomArrowEntity(Level world, double x, double y, double z) {
        super((EntityType)AoAProjectiles.ARROW.get(), world);
        this.setPos(x, y, z);
    }

    public CustomArrowEntity(Level world, ItemStack weaponStack, LivingEntity shooter, double baseDamage) {
        this(world, shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.setOwner((Entity)shooter);
        this.setBaseDamage(baseDamage);
        this.firedFromWeapon = weaponStack;
    }

    public static CustomArrowEntity fromArrow(AbstractArrow baseArrow, @Nullable ItemStack weaponStack, LivingEntity shooter, double baseDamage) {
        CustomArrowEntity arrow = new CustomArrowEntity((EntityType<? extends Arrow>)((EntityType)AoAProjectiles.ARROW.get()), baseArrow.level());
        arrow.setOwner((Entity)shooter);
        arrow.setCustomName(baseArrow.getCustomName());
        arrow.setCustomNameVisible(baseArrow.isCustomNameVisible());
        arrow.setBaseDamage(baseDamage);
        arrow.setCritArrow(baseArrow.isCritArrow());
        arrow.setPierceLevel(baseArrow.getPierceLevel());
        arrow.igniteForTicks(baseArrow.getRemainingFireTicks());
        arrow.setSoundEvent(arrow.getHitGroundSoundEvent());
        arrow.setPos(baseArrow.position().equals((Object)Vec3.ZERO) ? shooter.getEyePosition().subtract(0.0, (double)0.1f, 0.0) : baseArrow.position());
        arrow.setDeltaMovement(baseArrow.getDeltaMovement());
        arrow.setXRot(baseArrow.getXRot());
        arrow.setYRot(baseArrow.getYRot());
        arrow.setPickupItemStack(baseArrow.getPickupItemStackOrigin());
        arrow.xRotO = baseArrow.xRotO;
        arrow.yRotO = baseArrow.yRotO;
        arrow.lastState = baseArrow.lastState;
        arrow.inGround = baseArrow.inGround;
        arrow.pickup = baseArrow.pickup;
        arrow.shakeTime = baseArrow.shakeTime;
        arrow.piercedAndKilledEntities = baseArrow.piercedAndKilledEntities;
        arrow.piercingIgnoreEntityIds = baseArrow.piercingIgnoreEntityIds;
        if (weaponStack != null) {
            arrow.firedFromWeapon = weaponStack.copy();
            Level level = arrow.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EnchantmentHelper.onProjectileSpawned((ServerLevel)serverlevel, (ItemStack)weaponStack, (AbstractArrow)arrow, p_348347_ -> {
                    arrow.firedFromWeapon = null;
                });
            }
        }
        return arrow;
    }

    public void tick() {
        Item item;
        ItemStack weaponStack = this.getWeaponItem();
        if (weaponStack != null && (item = weaponStack.getItem()) instanceof ArrowFiringWeapon) {
            ArrowFiringWeapon arrowFiringWeapon = (ArrowFiringWeapon)item;
            arrowFiringWeapon.tickArrow(this, this.getOwner(), weaponStack);
        }
        super.tick();
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return this.ignoreExplosions;
    }

    public void setIgnoreExplosions() {
        this.ignoreExplosions = true;
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        Item item;
        this.lastState = this.level().getBlockState(hitResult.getBlockPos());
        ItemStack weaponStack = this.getWeaponItem();
        if (weaponStack != null && (item = weaponStack.getItem()) instanceof ArrowFiringWeapon) {
            ArrowFiringWeapon arrowFiringWeapon = (ArrowFiringWeapon)item;
            arrowFiringWeapon.onBlockImpact(this, this.getOwner(), hitResult, weaponStack);
        }
        this.lastState.onProjectileHit(this.level(), this.lastState, hitResult, (Projectile)this);
        Vec3 impactVelocity = hitResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(impactVelocity);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (weaponStack != null) {
                this.hitBlockEnchantmentEffects(serverlevel, hitResult, weaponStack);
            }
        }
        Vec3 embedPos = this.position().subtract(impactVelocity.normalize().scale((double)0.05f));
        this.setPosRaw(embedPos.x, embedPos.y, embedPos.z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEvents.ARROW_HIT);
        this.resetPiercedEntities();
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        ArrowFiringWeapon weapon;
        Item item;
        ArrowFiringWeapon arrowFiringWeapon;
        Entity target = hitResult.getEntity();
        Entity owner = this.getOwner();
        float velocity = (float)this.getDeltaMovement().length();
        float damage = (float)this.getBaseDamage();
        ItemStack weaponStack = this.getWeaponItem();
        DamageSource damageSource = this.damageSources().arrow((AbstractArrow)this, (Entity)(owner != null ? owner : this));
        ArrowFiringWeapon arrowFiringWeapon2 = arrowFiringWeapon = weaponStack != null && (item = weaponStack.getItem()) instanceof ArrowFiringWeapon ? (weapon = (ArrowFiringWeapon)item) : null;
        if (weaponStack != null && (item = this.level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)item;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)level, (ItemStack)weaponStack, (Entity)target, (DamageSource)damageSource, (float)damage);
        }
        if (arrowFiringWeapon != null) {
            damage = arrowFiringWeapon.getArrowDamage(this, owner, hitResult, weaponStack, damage, velocity, this.isCritArrow());
        }
        damage = Math.max(damage, 0.0f);
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(target.getId());
        }
        boolean isEnderman = target.getType() == EntityType.ENDERMAN;
        int fireTicks = target.getRemainingFireTicks();
        if (this.isOnFire() && !isEnderman) {
            target.igniteForSeconds(5.0f);
        }
        if (target.hurt(damageSource, damage)) {
            if (isEnderman) {
                return;
            }
            if (owner instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)owner;
                shooter.setLastHurtMob(target);
            }
            if (arrowFiringWeapon != null) {
                arrowFiringWeapon.onEntityImpact(this, owner, hitResult, weaponStack, velocity);
            }
            if (target instanceof LivingEntity) {
                ServerPlayer serverPlayer;
                LivingEntity livingTarget = (LivingEntity)target;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    livingTarget.setArrowCount(livingTarget.getArrowCount() + 1);
                }
                this.doKnockback(livingTarget, damageSource);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)livingTarget, (DamageSource)damageSource, (ItemStack)weaponStack);
                }
                this.doPostHurtEffects(livingTarget);
                if (livingTarget != owner && livingTarget instanceof Player && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!target.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(livingTarget);
                }
                if (owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (this.shotFromCrossbow()) {
                        if (this.piercedAndKilledEntities != null) {
                            CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverPlayer, (Collection)this.piercedAndKilledEntities);
                        } else if (!target.isAlive()) {
                            CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverPlayer, List.of(target));
                        }
                    }
                }
            }
            this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            target.setRemainingFireTicks(fireTicks);
            this.deflect(ProjectileDeflection.REVERSE, target, owner, false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    public boolean shotFromCrossbow() {
        ItemStack weapon = this.getWeaponItem();
        return weapon != null && weapon.getItem() instanceof CrossbowItem;
    }
}

