/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.trader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.variant.UndeadHeraldTrade;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.base.AoATrader;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;

public class UndeadHeraldEntity
extends AoATrader {
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new AoATrader.TradeListBuilder().trades(1, AoATrader.BuildableTrade.forItem((ItemLike)AoABlocks.ENERGY_BANNER.base()).itemCost((ItemLike)AoAItems.SILVER_COIN, 4).xp(20).stock(729), AoATrader.BuildableTrade.forItem((ItemLike)AoABlocks.SPIRIT_BANNER.base()).itemCost((ItemLike)AoAItems.SILVER_COIN, 4).xp(20).stock(729), AoATrader.BuildableTrade.forItem((ItemLike)AoABlocks.RAGE_BANNER.base()).itemCost((ItemLike)AoAItems.SILVER_COIN, 4).xp(20).stock(729)).build();

    public UndeadHeraldEntity(EntityType<? extends AoATrader> entityType, Level world) {
        super(entityType, world);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound() {
        return SoundEvents.SKELETON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SKELETON_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    @Override
    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.SKELETON_AMBIENT;
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
        }
    }

    public void playCelebrateSound() {
    }

    @Override
    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.tickCount > 72000;
    }

    @Override
    public int getMaxTradesToUnlock(int newProfessionLevel) {
        return newProfessionLevel == 1 ? 4 : 2;
    }

    @Override
    protected void updateTrades() {
        Int2ObjectMap<VillagerTrades.ItemListing[]> trades = this.getTradesMap();
        if (trades != null && !trades.isEmpty() && this.getVillagerData().getLevel() == 1) {
            MerchantOffers offers = this.getOffers();
            this.addOffersFromItemListings(offers, (VillagerTrades.ItemListing[])trades.get(1), this.getMaxTradesToUnlock(this.getVillagerData().getLevel()));
            offers.addAll(UndeadHeraldTrade.getExtraTradesFor(this));
        }
    }

    @Override
    @Nullable
    public Int2ObjectMap<VillagerTrades.ItemListing[]> getTradesMap() {
        return TRADES;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.ifValidSpawnBlock();
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<UndeadHeraldEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(16.0).moveSpeed(0.14375f).followRange(16.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this).setAnimationSpeed((double)1.35f));
    }
}

