/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.trader;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.WorldUtil;

public abstract class AoABanker
extends PathfinderMob {
    public AoABanker(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected boolean isOverworldNPC() {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isOverworldNPC() || !WorldUtil.isWorld(this.level(), Level.OVERWORLD) || this.tickCount >= 48000;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.getItem() == Items.NAME_TAG && (result = heldStack.interactLivingEntity(player, (LivingEntity)this, hand)).consumesAction()) {
            return result;
        }
        if (this.isAlive() && !player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                this.openScreen(pl);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected abstract void openScreen(ServerPlayer var1);
}

