/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.animal.precasia.DeinotheriumEntity;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SpinoledonEntity
extends AoAMeleeMob<SpinoledonEntity> {
    public static final EntityDataHolder<Boolean> LUNGING = EntityDataHolder.register(SpinoledonEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.lunging, (entity, value) -> {
        entity.lunging = value;
    });
    private static final AttributeModifier LUNGE_DAMAGE_BONUS = new AttributeModifier(AdventOfAscension.id("lunge_damage"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private boolean lunging = false;

    public SpinoledonEntity(EntityType<? extends SpinoledonEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setParts(new AoAEntityPart<SpinoledonEntity>(this, this.getBbWidth(), 0.875f, 0.0f, 1.0625f, this.getBbWidth()), new AoAEntityPart<SpinoledonEntity>(this, 0.5f, 0.8125f, 0.0f, 1.375f, this.getBbWidth() + 0.625f).setDamageMultiplier(1.1f), new AoAEntityPart<SpinoledonEntity>(this, 0.5f, 0.5f, 0.0f, 1.5625f, this.getBbWidth() + 1.125f).setDamageMultiplier(1.1f), new AoAEntityPart<SpinoledonEntity>(this, 0.5f, 0.5f, 0.0f, 1.5625f, this.getBbWidth() + 1.625f).setDamageMultiplier(1.25f), new AoAEntityPart<SpinoledonEntity>(this, this.getBbWidth(), 0.625f, 0.0f, 1.1875f, -this.getBbWidth()).setDamageMultiplier(0.9f), new AoAEntityPart<SpinoledonEntity>(this, 0.625f, 0.5625f, 0.0f, 1.125f, -this.getBbWidth() - 0.6875f).setDamageMultiplier(0.75f));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, LUNGING);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 100 == 0) {
            if (!this.level().isDay()) {
                AttributeUtil.applyTransientModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            } else {
                AttributeUtil.removeModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            }
        }
    }

    @Override
    public List<ExtendedSensor<? extends SpinoledonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null || target instanceof DeinotheriumEntity;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<? extends SpinoledonEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.level().isDay() ? entity.getRandom().nextInt(30, 60) : entity.getRandom().nextInt(60, 120))})});
    }

    @Override
    public BrainActivityGroup<? extends SpinoledonEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().closeEnoughDist((entity, target) -> 2), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration()).whenStarting(entity -> {
            LUNGING.set((Entity)entity, entity.distanceToSqr((Entity)BrainUtils.getTargetOfEntity((LivingEntity)entity)) < 4.0);
            if (LUNGING.is((Entity)entity, true)) {
                AttributeUtil.applyTransientModifier((LivingEntity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, LUNGE_DAMAGE_BONUS);
            } else {
                AttributeUtil.removeModifier((LivingEntity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, LUNGE_DAMAGE_BONUS);
            }
        })});
    }

    public int getMaxHeadXRot() {
        return 65;
    }

    public int getMaxHeadYRot() {
        return 40;
    }

    public int getHeadRotSpeed() {
        return 40;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_SPINOLEDON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_SPINOLEDON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SPINOLEDON_HURT.get();
    }

    @Override
    protected float getStepWeight() {
        return 5.0f;
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 1.4f;
    }

    @Override
    public int getCurrentSwingDuration() {
        return this.lunging ? 24 : 11;
    }

    @Override
    protected int getPreAttackTime() {
        return this.lunging ? 13 : 4;
    }

    @Override
    protected double getAttackReach() {
        return 3.05f;
    }

    @Override
    protected void onAttack(Entity target) {
        Animal animal;
        if (target instanceof Animal && (animal = (Animal)target).getHealth() <= 0.0f) {
            this.heal(animal.getMaxHealth() / 10.0f);
        }
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (damageContainer.getSource().is(DamageTypeTags.IS_FIRE) && this.level().getFluidState(BlockPos.containing((Position)this.getEyePosition())).getFluidType() == AoAFluidTypes.TAR.get() && this.level().getFluidState(this.blockPosition().above()).getFluidType() == AoAFluidTypes.TAR.get()) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.LARGE_SMOKE, (Entity)this).colourOverride(255, 255, 255, 255).spawnNTimes(20).sendToAllPlayersTrackingEntity(level2, (Entity)this);
                if (this.isDeadOrDying()) {
                    AoAScheduler.scheduleSyncronisedTask(() -> EntitySpawningUtil.spawnEntity(level2, (EntityType)AoAMonsters.SKELETAL_ABOMINATION.get(), this.position(), MobSpawnType.CONVERSION, abomination -> {
                        abomination.setXRot(this.getXRot());
                        abomination.setYRot(this.getYRot());
                        abomination.setYHeadRot(this.getYHeadRot());
                    }), 19 - this.deathTime);
                }
            }
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.and((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, random) -> pos.getY() >= 60 || pos.getY() <= -13)).difficultyBasedSpawnChance(0.05f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SpinoledonEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(51.0).armour(4.0, 4.0).moveSpeed(0.3).meleeStrength(9.5).knockbackResist(0.7f).aggroRange(16.0).followRange(32.0);
    }

    @Override
    protected int getAttackSwingDuration() {
        return this.lunging ? 25 : 11;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attack", 0, state -> {
            if (this.swinging) {
                if (this.lunging) {
                    state.setControllerSpeed(2.0f);
                    return state.setAndContinue(AoAAnimations.ATTACK_POUNCE);
                }
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(DefaultAnimations.ATTACK_BITE);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }));
    }
}

