/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.animal.precasia.HorndronEntity;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SmilodonEntity
extends AoAMeleeMob<SmilodonEntity> {
    public SmilodonEntity(EntityType<? extends SmilodonEntity> entityType, Level level) {
        super((EntityType<? extends AoAMeleeMob>)entityType, level);
        this.setParts(new AoAEntityPart<SmilodonEntity>(this, 0.4375f, 0.5625f, 0.0f, 0.6875f, this.getBbWidth() * 2.0f - 0.125f).setDamageMultiplier(1.25f), new AoAEntityPart<SmilodonEntity>(this, this.getBbWidth(), 0.8125f, 0.0f, 0.5625f, this.getBbWidth()), new AoAEntityPart<SmilodonEntity>(this, 0.5625f, 0.8125f, 0.0f, 0.5625f, -this.getBbWidth() + 0.0625f).setDamageMultiplier(0.9f));
    }

    @Override
    public List<ExtendedSensor<? extends SmilodonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null || target instanceof HorndronEntity;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<? extends SmilodonEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.level().isDay() ? entity.getRandom().nextInt(30, 60) : entity.getRandom().nextInt(60, 120))})});
    }

    @Override
    public BrainActivityGroup<? extends SmilodonEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(entity.distanceToSqr((Entity)target) < 8.0 ? 1.0f : 1.5f)), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 100 == 0) {
            if (this.level().isDay()) {
                AttributeUtil.applyTransientModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            } else {
                AttributeUtil.removeModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            }
        }
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (damageContainer.getSource().is(DamageTypeTags.IS_FIRE) && this.level().getFluidState(BlockPos.containing((Position)this.getEyePosition())).getFluidType() == AoAFluidTypes.TAR.get() && this.level().getFluidState(this.blockPosition().above()).getFluidType() == AoAFluidTypes.TAR.get()) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.LARGE_SMOKE, (Entity)this).colourOverride(255, 255, 255, 255).spawnNTimes(20).sendToAllPlayersTrackingEntity(level2, (Entity)this);
                if (this.isDeadOrDying()) {
                    AoAScheduler.scheduleSyncronisedTask(() -> EntitySpawningUtil.spawnEntity(level2, (EntityType)AoAMonsters.SKELETAL_ABOMINATION.get(), this.position(), MobSpawnType.CONVERSION, abomination -> {
                        abomination.setXRot(this.getXRot());
                        abomination.setYRot(this.getYRot());
                        abomination.setYHeadRot(this.getYHeadRot());
                    }), 19 - this.deathTime);
                }
            }
        }
    }

    @Override
    protected void onAttack(Entity target) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (this.rand().oneInNChance(10)) {
                    EntityUtil.applyPotions((Entity)livingTarget, new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 20).level(3).hideParticles().hideEffectIcon());
                    ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.CRIT, (Entity)livingTarget).spawnNTimes(10).sendToAllPlayersTrackingEntity(level2, (Entity)livingTarget);
                    this.level().playSound(null, livingTarget.blockPosition(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.HOSTILE);
                }
            }
        }
    }

    @Override
    protected double getAttackReach() {
        return 1.51 * (double)(this.isSprinting() ? 1.25f : 1.0f);
    }

    @Override
    protected int getAttackSwingDuration() {
        return 18;
    }

    @Override
    protected int getPreAttackTime() {
        return 9;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_SMILODON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SMILODON_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_SMILODON_DEATH.get();
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.noLowerThanY(60).difficultyBasedSpawnChance(0.1f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SmilodonEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(46.0).meleeStrength(8.0).moveSpeed(0.25).aggroRange(16.0).followRange(32.0).knockbackResist(0.3f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)this));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE));
    }
}

