/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class ScolopendisEntity
extends AoAMeleeMob<ScolopendisEntity> {
    public ScolopendisEntity(EntityType<? extends ScolopendisEntity> entityType, Level level) {
        super((EntityType<? extends AoAMeleeMob>)entityType, level);
        this.setParts(new AoAEntityPart<ScolopendisEntity>(this, this.getBbWidth(), this.getBbHeight(), 0.0f, 0.0f, this.getBbWidth()), new AoAEntityPart<ScolopendisEntity>(this, this.getBbWidth(), this.getBbHeight(), 0.0f, 0.0f, -this.getBbWidth()));
    }

    @Override
    protected double getAttackReach() {
        return 1.75;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 13;
    }

    @Override
    protected int getPreAttackTime() {
        return 8;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_SCOLOPENDIS_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)AoASounds.ENTITY_SCOLOPENDIS_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_SCOLOPENDIS_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.SPIDER_STEP;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (RandomUtil.oneInNChance((int)10)) {
                EntityUtil.applyPotions((Entity)livingTarget, new EffectBuilder(MobEffects.CONFUSION, 400).hideParticles().isAmbient().level(1));
            }
        }
    }

    @Override
    public BrainActivityGroup<? extends ScolopendisEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(entity.distanceToSqr((Entity)target) < 16.0 ? 1.0f : 1.25f)), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.and((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, rand) -> {
            if (level.getLevel().dimension() != AoADimensions.PRECASIA || spawnType != MobSpawnType.NATURAL) {
                return true;
            }
            return pos.getY() <= 50 && rand.nextFloat() < 0.025f;
        }));
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<ScolopendisEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(43.0).moveSpeed(0.33).meleeStrength(8.5).aggroRange(16.0).followRange(32.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)this));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(0));
    }
}

