/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAWaterMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;

public class DunkleosteusEntity
extends AoAWaterMeleeMob<DunkleosteusEntity> {
    private static final int ATTACK_BITE = 0;
    private static final int ATTACK_SHOOT = 1;

    public DunkleosteusEntity(EntityType<? extends DunkleosteusEntity> entityType, Level level) {
        super((EntityType<? extends AoAWaterMeleeMob>)entityType, level);
        this.setParts(new AoAEntityPart<DunkleosteusEntity>(this, this.getBbWidth(), this.getBbHeight(), 0.0f, 0.0f, this.getBbWidth()), new AoAEntityPart<DunkleosteusEntity>(this, this.getBbWidth(), this.getBbHeight(), 0.0f, 0.0f, -this.getBbWidth()), new AoAEntityPart<DunkleosteusEntity>(this, this.getBbWidth() - 0.25f, 1.125f, 0.0f, 0.375f, -this.getBbWidth() * 2.0f));
    }

    protected boolean canRide(Entity vehicle) {
        return false;
    }

    @Override
    protected float getAttackVectorPositionOffset() {
        return 2.75f;
    }

    @Override
    public List<ExtendedSensor<? extends DunkleosteusEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor().setPredicate((player, entity) -> player.isInWater()), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target.isInWater() && (target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null || target instanceof Animal);
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<? extends DunkleosteusEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || !target.isInWater() || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(target instanceof Player ? 1.25f : 1.0f)), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public int getMaxAirSupply() {
        return 2400;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return super.getAmbientSound();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return super.getHurtSound(source);
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return super.getDeathSound();
    }

    @Override
    public int getCurrentSwingDuration() {
        return ATTACK_STATE.is((Entity)this, 0) ? 11 : 31;
    }

    @Override
    protected int getPreAttackTime() {
        return ATTACK_STATE.is((Entity)this, 0) ? 4 : 11;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.noHigherThanY(55).difficultyBasedSpawnChance(0.05f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<DunkleosteusEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(70.0).meleeStrength(7.0).moveSpeed(1.2f).swimSpeedMod(1.5).followRange(32.0).knockbackResist(0.9f).aggroRange(32.0).followRange(64.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim/SwimSprint", 0, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? AoAAnimations.SWIM_SPRINT : DefaultAnimations.SWIM);
            }
            return PlayState.STOP;
        }));
        controllers.add(AoAAnimations.dynamicAttackController(this, state -> ATTACK_STATE.is((Entity)this, 0) ? DefaultAnimations.ATTACK_BITE : DefaultAnimations.ATTACK_SHOOT));
    }
}

