/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import com.mojang.datafixers.util.Pair;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DefaultAnimations;

public class YetiEntity
extends AoAMeleeMob<YetiEntity> {
    private static final int ATTACK_STRIKE = 0;
    private static final int ATTACK_SWING = 1;

    public YetiEntity(EntityType<? extends YetiEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_YETI_AMBIENT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_YETI_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_YETI_HURT.get();
    }

    @Override
    public BrainActivityGroup<YetiEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableMeleeAttack(7).attackInterval(entity -> 16).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 0)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)this, (int)16)), (Object)3), Pair.of((Object)new AnimatableMeleeAttack(4).attackInterval(entity -> 14).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 1)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)this, (int)14)), (Object)1)}).startCondition(entity -> !BrainUtils.isOnSpecialCooldown((LivingEntity)this))});
    }

    @Override
    protected void onAttack(Entity target) {
        super.onAttack(target);
        if (ATTACK_STATE.is((Entity)this, 1) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            DamageUtil.doScaledKnockback(livingTarget, (LivingEntity)this, 1.1f, 1.0, 1.25, 1.0);
        }
    }

    @Override
    protected int getAttackSwingDuration() {
        return ATTACK_STATE.is((Entity)this, 0) ? 16 : 14;
    }

    @Override
    protected int getPreAttackTime() {
        return ATTACK_STATE.is((Entity)this, 0) ? 7 : 4;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(45).spawnChance(0.5f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<YetiEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(25.0).armour(2.0, 2.0).moveSpeed(0.2875).meleeStrength(5.0).followRange(12.0).aggroRange(12.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), AoAAnimations.dynamicAttackController(this, state -> ATTACK_STATE.is((Entity)this, 0) ? DefaultAnimations.ATTACK_STRIKE : DefaultAnimations.ATTACK_SWING)});
    }
}

