/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.TreeSpiritSpriteEntity;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomHeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TreeSpiritEntity
extends AoARangedMob<TreeSpiritEntity> {
    private static final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("misc.activate").thenLoop("misc.active_idle");
    private static final RawAnimation DEACTIVATE = RawAnimation.begin().thenPlay("misc.deactivate");

    public TreeSpiritEntity(EntityType<? extends TreeSpiritEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
        this.setImmobile(true);
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WOOD_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.TREE_FALL.get();
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState blockState) {
    }

    @Override
    public List<ExtendedSensor<? extends TreeSpiritEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<TreeSpiritEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new CustomHeldBehaviour(owner -> {
            if (ATTACK_STATE.is((Entity)owner, 1) && BrainUtils.getTargetOfEntity((LivingEntity)owner) == null) {
                ATTACK_STATE.set((Entity)owner, 0);
            }
        })});
    }

    @Override
    public BrainActivityGroup<TreeSpiritEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new SetRetaliateTarget().attackablePredicate(target -> DamageUtil.isAttackable(target) && this.distanceToSqr(target.position()) < Math.pow(this.getAttributeValue((Holder)AoAAttributes.AGGRO_RANGE), 2.0)).whenStarting(owner -> ATTACK_STATE.set((Entity)owner, 1)).startCondition(entity -> this.level().getDifficulty() != Difficulty.PEACEFUL)});
    }

    @Override
    public BrainActivityGroup<TreeSpiritEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            Player pl;
            return !target.isAlive() || this.level().getDifficulty() == Difficulty.PEACEFUL || target instanceof Player && ((pl = (Player)target).isCreative() || pl.isSpectator()) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0);
        }), new AnimatableRangedAttack(15).attackInterval(entity -> RandomUtil.randomNumberBetween((int)15, (int)35)).startCondition(entity -> this.level().getDifficulty() != Difficulty.PEACEFUL)});
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.absMoveTo(Math.floor(this.getX()) + 0.5, this.getY(), Math.floor(this.getZ()) + 0.5, 0.0f, 0.0f);
        this.setOldPosAndRot();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public Component getName() {
        if (ATTACK_STATE.is((Entity)this, 0)) {
            return Component.translatable((String)"entity.aoa3.dead_tree");
        }
        return super.getName();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean wasMaxHealth;
        if (source.is(Tags.DamageTypes.IS_TECHNICAL)) {
            return super.hurt(source, amount);
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            amount *= 1.25f;
        }
        boolean bl = wasMaxHealth = this.isAlive() && this.getHealth() == this.getMaxHealth();
        if (super.hurt(source, amount)) {
            Player player;
            if (!this.level().isClientSide && wasMaxHealth && (player = PlayerUtil.getPlayerOrOwnerIfApplicable(source.getEntity())) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                if (this.getHealth() <= 0.0f) {
                    AdvancementUtil.grantCriterion(pl, AdventOfAscension.id("completionist/mightiest_tree_in_the_forest"), "tree_spirit_instakill");
                }
            }
            return true;
        }
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void playerTouch(Player player) {
    }

    protected void doPush(Entity entity) {
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_SHOOT.get();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (target instanceof TreeSpiritEntity) {
            return;
        }
        super.doRangedAttackEntity(projectile, target);
    }

    @Override
    public void onProjectileAttack(@Nullable BaseMobProjectile projectile, Entity target) {
        this.level().playSound(null, projectile.getX(), projectile.getY(), projectile.getZ(), (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_SPRITE_IMPACT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    @Override
    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.level().addFreshEntity((Entity)this.getNewProjectileInstance());
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new TreeSpiritSpriteEntity(this, (Entity)this.getTarget());
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55).spawnChance(0.1f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<TreeSpiritEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(35.0).moveSpeed(0.0).projectileDamage(6.0).knockbackResist(1.0).aggroRange(16.0).followRange(32.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Living", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 1)) {
                return state.setAndContinue(ACTIVATE);
            }
            if (state.getController().getCurrentRawAnimation() != null) {
                return state.setAndContinue(DEACTIVATE);
            }
            return PlayState.STOP;
        }));
    }
}

