/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.monster.overworld.ChargerEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class KingChargerEntity
extends AoAMeleeMob<KingChargerEntity> {
    private static final AttributeModifier MINION_FOLLOW_RANGE_MOD = new AttributeModifier(AdventOfAscension.id("king_charger_buff"), 40.0, AttributeModifier.Operation.ADD_VALUE);
    private int nextChargerSpawn = 0;

    public KingChargerEntity(EntityType<? extends KingChargerEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    public BrainActivityGroup<KingChargerEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)).whenStopping(entity -> EntityRetrievalUtil.getEntities((Entity)entity, (double)40.0, ally -> ally instanceof ChargerEntity).forEach(charger -> BrainUtils.setTargetOfEntity((LivingEntity)charger, (LivingEntity)BrainUtils.getTargetOfEntity((LivingEntity)entity)))), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    @Override
    public BrainActivityGroup<KingChargerEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.125f)), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_KING_CHARGER_HURT.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.nextChargerSpawn < this.tickCount) {
            LivingEntity target = this.getTarget();
            if (target != null) {
                ChargerEntity charger = (ChargerEntity)EntitySpawningUtil.spawnEntity((ServerLevel)this.level(), (EntityType)AoAMonsters.CHARGER.get(), (Vec3i)RandomUtil.getRandomPositionWithinRange((BlockPos)target.blockPosition(), (int)40, (int)10, (int)40, (int)30, (int)0, (int)30, (boolean)true, (Level)this.level(), (int)2, (state, statePos) -> true), MobSpawnType.MOB_SUMMONED);
                charger.getAttribute(Attributes.FOLLOW_RANGE).addTransientModifier(MINION_FOLLOW_RANGE_MOD);
                if (charger != null) {
                    BrainUtils.setTargetOfEntity((LivingEntity)charger, (LivingEntity)target);
                }
            }
            this.nextChargerSpawn = this.tickCount + RandomUtil.randomNumberBetween((int)80, (int)140);
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.0625f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<KingChargerEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(75.0).moveSpeed(0.32).meleeStrength(9.0).knockbackResist(0.2).followRange(40.0).aggroRange(16.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(0)});
    }
}

