/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.ai.mob.MultiTypeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedRangedAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class IceGiantEntity
extends AoAMeleeMob<IceGiantEntity>
implements AoARangedAttacker {
    private int lastAttackTime = 0;

    public IceGiantEntity(EntityType<? extends IceGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected Brain.Provider<IceGiantEntity> brainProvider() {
        return Brain.provider(List.of(MemoryModuleType.ATTACK_TARGET), (Collection)ImmutableList.of());
    }

    protected void registerGoals() {
        TelegraphedMeleeAttackGoal<IceGiantEntity> meleeGoal = new TelegraphedMeleeAttackGoal<IceGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.getCurrentSwingDuration());
        TelegraphedRangedAttackGoal<IceGiantEntity> rangedGoal = new TelegraphedRangedAttackGoal<IceGiantEntity>(this).attackFrequency(0, 1).moveSpeedMod(0.0f).windUpTime(1);
        this.goalSelector.addGoal(1, (Goal)new MultiTypeAttackGoal((Object2IntFunction<Goal>)((Object2IntFunction)currentGoal -> {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return 0;
            }
            if (this.tickCount - this.lastAttackTime > 120) {
                return this.distanceToSqr((Entity)target) < 16.0 ? 0 : 1;
            }
            if (this.distanceToSqr((Entity)target) > 100.0 && !target.isFullyFrozen()) {
                return 1;
            }
            return this.getNavigation().createPath((Entity)target, 0) == null ? 1 : 0;
        }), meleeGoal, rangedGoal));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ICE_BREAK.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ICE_HIT.get();
    }

    @Override
    protected float getStepWeight() {
        return 3.0f;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    protected void customServerAiStep() {
        LivingEntity target;
        super.customServerAiStep();
        if (this.isUnderWater()) {
            AABB boundingBox = this.getBoundingBox();
            double width = boundingBox.maxX - boundingBox.minX;
            double depth = boundingBox.maxZ - boundingBox.minZ;
            double height = boundingBox.maxY - boundingBox.minY;
            int particleCount = (int)Math.ceil(3.0 + 10.0 * width * depth * height);
            TELParticlePacket packet = new TELParticlePacket(particleCount);
            for (int i = 0; i < particleCount; ++i) {
                packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)EntityTrackingParticleOptions.ambient(AoAParticleTypes.FREEZING_SNOWFLAKE), (Entity)this).lifespan(Mth.ceil((float)(3.0f / (this.random.nextFloat() * 0.8f + 0.2f)))).scaleMod(0.3f).velocity(RandomUtil.randomScaledGaussianValue((double)0.05), 0.0, RandomUtil.randomScaledGaussianValue((double)0.05)));
            }
            packet.sendToAllNearbyPlayers((ServerLevel)this.level(), this.position(), 10.0);
            this.remove(Entity.RemovalReason.KILLED);
        }
        if ((target = this.getTarget()) != null && target.isFullyFrozen()) {
            this.lastAttackTime = this.tickCount;
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canFreeze() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    protected void onAttack(Entity target) {
        this.lastAttackTime = this.tickCount;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            Entity entity = source.getDirectEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (DamageUtil.isMeleeDamage(source) && DamageUtil.isAttackable(attacker)) {
                    attacker.setTicksFrozen(attacker.getTicksFrozen() + 100);
                }
            }
            return true;
        }
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        double baseX = this.getX();
        double baseY = this.getEyeY();
        double baseZ = this.getZ();
        TELParticlePacket packet = new TELParticlePacket(5);
        for (int i = 0; i < 5; ++i) {
            double x = baseX + RandomUtil.randomScaledGaussianValue((double)0.5);
            double y = baseY + RandomUtil.randomScaledGaussianValue((double)0.5);
            double z = baseZ + RandomUtil.randomScaledGaussianValue((double)0.5);
            double targetX = target.getX() + RandomUtil.randomScaledGaussianValue((double)0.5);
            double targetY = target.getEyeY() + RandomUtil.randomScaledGaussianValue((double)0.5);
            double targetZ = target.getZ() + RandomUtil.randomScaledGaussianValue((double)0.5);
            packet.particle(ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.FREEZING_SNOWFLAKE, (Entity)this), (double)baseX, (double)baseY, (double)baseZ).scaleMod(0.4f).lifespan(Mth.ceil((float)(12.0f / (this.random.nextFloat() * 0.8f + 0.2f)))).velocity((targetX - x) * 0.1, (targetY - y) * 0.1, (targetZ - z) * 0.1));
        }
        if (this.tickCount % 5 == 0) {
            this.playSound((SoundEvent)AoASounds.ICE_WIND.get(), 1.5f, 1.0f);
        }
        packet.sendToAllNearbyPlayers((ServerLevel)this.level(), this.getEyePosition(), 200.0);
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (projectile == null && DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_ICEBEAM, (Entity)this, target.position()), target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE)) && (float)target.getTicksFrozen() <= (float)target.getTicksRequiredToFreeze() * 2.5f) {
            target.setTicksFrozen(target.getTicksFrozen() + 34);
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<IceGiantEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(150.0).moveSpeed(0.31).meleeStrength(10.0).projectileDamage(1.0).knockbackResist(1.0).followRange(40.0).stepHeight(1.5);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_SLAM).transitionLength(0)});
    }
}

