/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class BushBabyEntity
extends AoAMeleeMob<BushBabyEntity> {
    public BushBabyEntity(EntityType<? extends BushBabyEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.LEAFY_THUD.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 13;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(65);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<BushBabyEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(10.0).moveSpeed(0.34).meleeStrength(4.0).followRange(10.0).aggroRange(8.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(0)});
    }
}

