/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.nether;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.FireballEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessHeldAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomDelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class NethengeicBeastEntity
extends AoARangedMob<NethengeicBeastEntity> {
    private static final EntityDataAccessor<Boolean> FLAME_AURA = SynchedEntityData.defineId(NethengeicBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final RawAnimation FLAMETHROWER_ANIM = RawAnimation.begin().thenPlay("attack.flamethrower.start").thenPlay("attack.flamethrower.hold");
    private static final RawAnimation FLAMETHROWER_RELEASE_ANIM = RawAnimation.begin().thenPlay("attack.flamethrower.end");
    private static final RawAnimation FIRE_AURA_ANIM = RawAnimation.begin().thenPlay("misc.fire_aura");
    private static final RawAnimation FIRE_SPIN_ANIM = RawAnimation.begin().thenPlay("attack.fire_spin");
    private static final int FIREBALL = 0;
    private static final int FLAMETHROWER_OPEN = 1;
    private static final int FLAMETHROWER = 2;

    public NethengeicBeastEntity(EntityType<? extends NethengeicBeastEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
    }

    @Override
    public BrainActivityGroup<NethengeicBeastEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget().startCondition(entity -> !this.isDoingStationaryActivity()), new FloatToSurfaceOfFluid()});
    }

    @Override
    public BrainActivityGroup<NethengeicBeastEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new SetRetaliateTarget().attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    @Override
    public BrainActivityGroup<NethengeicBeastEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableRangedAttack(0).attackInterval(entity -> entity.getRandom().nextIntBetweenInclusive(10, 20)).attackRadius(24.0f).whenStarting(entity -> ATTACK_STATE.set((Entity)this, 0)).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)10)), (Object)30), Pair.of((Object)new CustomDelayedBehaviour(20).whenActivating(entity -> this.toggleAura()).cooldownFor(entity -> entity.getRandom().nextIntBetweenInclusive(180, 360)).whenStarting(entity -> {
            this.triggerAnim("posing", "fire_aura");
            if (!this.hasAura()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_FLAME_AURA_ACTIVATE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)25)), (Object)1), Pair.of((Object)((Object)new FlamethrowerAttack()), (Object)7), Pair.of((Object)((Object)new FlameSpinAttack()), (Object)7)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get())))});
    }

    @Override
    public int calculateKillXp() {
        int xp = super.calculateKillXp();
        return xp > 0 ? xp + 15 : 0;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundEvents.BLAZE_SHOOT;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new FireballEntity(this.level(), this, BaseMobProjectile.Type.PHYSICAL);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLAME_AURA, (Object)false);
    }

    public int getMaxHeadYRot() {
        return 10;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.CAMPFIRE_CRACKLE;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_DEATH.get();
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState blockState) {
    }

    public boolean hasAura() {
        return (Boolean)this.getEntityData().get(FLAME_AURA);
    }

    public void toggleAura() {
        this.getEntityData().set(FLAME_AURA, (Object)((Boolean)this.getEntityData().get(FLAME_AURA) == false ? 1 : 0));
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type != NeoForgeMod.EMPTY_TYPE.value();
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() != AoAMobEffects.NETHENGEIC_CURSE.get() && super.canBeAffected(effect);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            if (this.hasAura()) {
                for (int i = 0; i < 3; ++i) {
                    double cos = Math.cos(this.getX() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double sin = Math.sin(this.getZ() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double startX = cos * (double)this.getBbWidth() + this.getX();
                    double startZ = sin * (double)this.getBbWidth() + this.getZ();
                    double startY = this.getRandomY();
                    ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.FIRE_AURA, (Entity)this), (double)startX, (double)startY, (double)startZ).scaleMod(0.25f).colourOverride(1.0f, 1.0f, 1.0f, 0.75f).velocity(RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0).spawnParticles(this.level());
                }
            }
            ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.FLAME, (double)(this.getX() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f)), (double)(this.getEyeY() - 1.0 + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f)), (double)(this.getZ() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f))).spawnParticles(this.level());
            if (this.getRandom().nextInt(10) == 0) {
                ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMOKE, (double)this.getX(), (double)(this.getEyeY() - 1.0), (double)this.getZ()).spawnParticles(this.level());
                if (this.getDeltaMovement().horizontalDistanceSqr() == 0.0) {
                    ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.DRIPPING_LAVA, (double)this.getX(), (double)(this.getEyeY() - 1.0), (double)this.getZ()).spawnParticles(this.level());
                }
            }
        } else if (this.hasAura() && BrainUtils.getTargetOfEntity((LivingEntity)this) == null) {
            this.toggleAura();
        }
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        super.doRangedAttackEntity(projectile, target);
        if (projectile == null) {
            DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.position()), target, 1.0f);
            if (RandomUtil.oneInNChance((int)4) && target.getRemainingFireTicks() < 300) {
                target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 1));
            }
        }
    }

    @Override
    public void onProjectileAttack(@Nullable BaseMobProjectile projectile, Entity target) {
        target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 3));
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        if (EventHooks.canEntityGrief((Level)this.level(), (Entity)projectile.getOwner()) && projectile instanceof FireballEntity) {
            BlockPos firePos = pos.offset(sideHit.getNormal());
            if (!this.level().getBlockState(firePos).canBeReplaced()) {
                firePos = pos.relative(Direction.UP);
                if (!this.level().getBlockState(firePos).canBeReplaced()) {
                    return;
                }
            }
            this.level().setBlock(firePos, Blocks.FIRE.defaultBlockState(), 3);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.hasAura()) {
            if (DamageUtil.isMeleeDamage(source)) {
                Entity entity = source.getDirectEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_FIRE_RECOIL, (Entity)this), (Entity)attacker, 3.0f);
                    attacker.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, attacker.getRemainingFireTicks()) / 20.0f) + 2));
                    attacker.addEffect(new MobEffectInstance(AoAMobEffects.NETHENGEIC_CURSE, 200));
                }
            } else if (DamageUtil.isEnergyDamage(source)) {
                this.heal(amount);
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.noPeacefulSpawn().noSpawnOn(Blocks.NETHER_WART_BLOCK).ifValidSpawnBlock().and((entityType, levelAccessor, spawnReason, blockPos, rand) -> {
            Level level;
            block3: {
                block2: {
                    if (!(levelAccessor instanceof Level)) break block2;
                    level = (Level)levelAccessor;
                    if (spawnReason == MobSpawnType.STRUCTURE || spawnReason == MobSpawnType.NATURAL) break block3;
                }
                return true;
            }
            return EntityRetrievalUtil.getEntities((Level)level, (AABB)new AABB((double)(blockPos.getX() - 15), (double)(blockPos.getY() - 2), (double)(blockPos.getZ() - 15), (double)(blockPos.getX() + 15), (double)(blockPos.getY() + 2), (double)(blockPos.getZ() + 15)), entity -> entity.getType() == AoAMonsters.NETHENGEIC_BEAST.get()).isEmpty();
        });
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<NethengeicBeastEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(120.0).moveSpeed(0.25).projectileDamage(10.0).aggroRange(16.0).followRange(24.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "living", 0, event -> {
            if (!ATTACK_STATE.is((Entity)this, 2)) {
                event.getController().setAnimationSpeed((double)(1.0f + (1.0f - this.getHealth() / this.getMaxHealth()) * 5.0f));
                event.getController().setAnimation(DefaultAnimations.LIVING);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(AoAAnimations.genericHeldPoseController(this, FLAMETHROWER_ANIM, FLAMETHROWER_RELEASE_ANIM, entity -> ATTACK_STATE.isAny((Entity)entity, 1, 2)).triggerableAnim("fire_aura", FIRE_AURA_ANIM).triggerableAnim("fire_spin", FIRE_SPIN_ANIM));
    }

    private static class FlamethrowerAttack
    extends ConditionlessHeldAttack<NethengeicBeastEntity> {
        public FlamethrowerAttack() {
            this.requiresTarget();
            this.onTick(entity -> {
                if (this.getRunningTime() <= 24) {
                    return true;
                }
                AoAMonster.ATTACK_STATE.set((Entity)entity, 2);
                Vec3 position = entity.position();
                double baseX = position.x;
                double baseY = entity.getEyeY() - 1.0;
                double baseZ = position.z;
                TELParticlePacket packet = new TELParticlePacket(new ParticleBuilder[]{ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)baseX, (double)baseY, (double)baseZ)});
                for (int i = 0; i < 5; ++i) {
                    Vec3 velocity = this.target.getEyePosition().subtract(baseX + RandomUtil.randomScaledGaussianValue((double)0.5), baseY + RandomUtil.randomScaledGaussianValue((double)0.5), baseZ + RandomUtil.randomScaledGaussianValue((double)0.5)).normalize().scale(0.75);
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.BURNING_FLAME, (Entity)entity), (double)baseX, (double)baseY, (double)baseZ).colourOverride(0.0f, 0.0f, 0.0f, 0.0f).scaleMod(0.35f).velocity(velocity.x, velocity.y, velocity.z));
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)baseX, (double)baseY, (double)baseZ).velocity(velocity.x, velocity.y, velocity.z));
                }
                packet.sendToAllNearbyPlayers((ServerLevel)entity.level(), EntityUtil.getEntityCenter((Entity)entity), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.playSound((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.startCondition(entity -> {
                double aggroRange;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                if (target == null) {
                    return false;
                }
                double dist = target.distanceToSqr((Entity)entity);
                return dist <= (aggroRange = entity.getAttributeValue((Holder)AoAAttributes.AGGRO_RANGE)) * aggroRange && BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.stopIf(entity -> {
                double distanceCutoff;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                if (target == null) {
                    return true;
                }
                double dist = target.distanceToSqr((Entity)entity);
                return dist > (distanceCutoff = entity.getAttributeValue(Attributes.FOLLOW_RANGE) * 0.75) * distanceCutoff || this.getRunningTime() > 80 && entity.getRandom().nextInt(100) == 0 || !BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.cooldownFor(entity -> 160);
            this.whenStopping(entity -> {
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)20);
                AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
            });
            this.whenStarting(entity -> AoAMonster.ATTACK_STATE.set((Entity)entity, 1));
        }
    }

    private static class FlameSpinAttack
    extends ConditionlessHeldAttack<NethengeicBeastEntity> {
        public FlameSpinAttack() {
            this.requiresTarget();
            this.runFor(entity -> 20);
            this.onTick(entity -> {
                if (this.getRunningTime() <= 5) {
                    return true;
                }
                TELParticlePacket packet = new TELParticlePacket();
                for (int i = -180; i <= 180; i += 8) {
                    double angle = Math.toRadians(i * entity.tickCount);
                    double x = entity.getX() + 2.0 * Math.cos(angle);
                    double y = entity.getY() + (double)1.3f;
                    double z = entity.getZ() + 2.0 * Math.sin(angle);
                    double velocityX = x - entity.getX();
                    double velocityZ = z - entity.getZ();
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.BURNING_FLAME, (Entity)entity), (double)x, (double)y, (double)z).colourOverride(0.0f, 0.0f, 0.0f, 0.0f).scaleMod(0.35f).lifespan(Mth.ceil((float)(3.0f / (((NethengeicBeastEntity)entity).random.nextFloat() * 0.8f + 0.2f)))).velocity(velocityX, (double)-0.6f, velocityZ));
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)x, (double)y, (double)z).velocity(velocityX, (double)-0.6f, velocityZ));
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMOKE, (double)x, (double)y, (double)z));
                }
                packet.sendToAllNearbyPlayers((ServerLevel)entity.level(), EntityUtil.getEntityCenter((Entity)entity), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.playSound((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.startCondition(entity -> {
                if (entity.hasAura()) {
                    return false;
                }
                LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
                if (target == null) {
                    return false;
                }
                return entity.distanceToSqr((Entity)target) < 25.0 || !EntityRetrievalUtil.getEntities((Entity)entity, (double)5.0, entity2 -> PlayerUtil.getPlayerOrOwnerIfApplicable(entity2) != null).isEmpty();
            });
            this.cooldownFor(entity -> entity.getRandom().nextIntBetweenInclusive(100, 140));
            this.whenStarting(entity -> entity.triggerAnim("posing", "fire_spin"));
            this.whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)20));
        }
    }
}

