/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.misc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class ThornyPlantSproutEntity
extends AoAMeleeMob<ThornyPlantSproutEntity> {
    private boolean isCrop = false;

    public ThornyPlantSproutEntity(EntityType<? extends ThornyPlantSproutEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setPersistenceRequired();
        this.attackReach = 2.0;
    }

    public ThornyPlantSproutEntity(Level world, BlockPos plantPos) {
        this((EntityType<? extends ThornyPlantSproutEntity>)((EntityType)AoAMiscEntities.THORNY_PLANT_SPROUT.get()), world);
        this.moveTo((double)((float)plantPos.getX() + 0.5f) + this.rand().nextGaussian() * (double)0.1f, (float)plantPos.getY() + 0.1f, (double)((float)plantPos.getZ() + 0.5f) + this.rand().nextGaussian() * (double)0.1f, this.rand().nextFloat() * 360.0f, 0.0f);
        this.isCrop = true;
    }

    @Override
    public BrainActivityGroup<ThornyPlantSproutEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget()});
    }

    @Override
    public BrainActivityGroup<ThornyPlantSproutEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target))});
    }

    @Override
    public BrainActivityGroup<ThornyPlantSproutEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    @Override
    public List<ExtendedSensor<? extends ThornyPlantSproutEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target.getType() != entity.getType() && (target instanceof Monster || target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null);
        }).setScanRate(entity -> 20), new HurtBySensor()});
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsCropSprout", this.isCrop);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("IsCropSprout", 1)) {
            this.isCrop = compound.getBoolean("IsCropSprout");
        }
    }

    @Override
    protected void customServerAiStep() {
        if (this.isCrop && this.tickCount % 5 == 0 && this.level().getBlockState(BlockPos.containing((double)this.getX(), (double)(this.getY() + 0.25), (double)this.getZ())).getBlock() != AoABlocks.THORNY_PLANT_CROP.get()) {
            this.discard();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkSpawnConditions(EntityType<?> entityType, LevelAccessor levelAccessor, MobSpawnType spawnReason, BlockPos blockPos, RandomSource rand) {
        if (!(levelAccessor instanceof Level)) return true;
        Level level = (Level)levelAccessor;
        if (spawnReason != MobSpawnType.STRUCTURE && spawnReason != MobSpawnType.NATURAL) {
            return true;
        }
        if (!levelAccessor.getBlockState(blockPos.below()).is(BlockTags.DIRT)) return false;
        if (!EntityRetrievalUtil.getEntities((Level)level, (AABB)new AABB((double)(blockPos.getX() - 15), (double)(blockPos.getY() - 10), (double)(blockPos.getZ() - 15), (double)(blockPos.getX() + 15), (double)(blockPos.getY() + 10), (double)(blockPos.getZ() + 15)), ThornyPlantSproutEntity.class::isInstance).isEmpty()) return false;
        return true;
    }

    public void move(MoverType pType, Vec3 pPos) {
    }

    public void push(double pX, double pY, double pZ) {
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 15;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.level().getBlockState(this.blockPosition().above()).getBlock() == AoABlocks.THORNY_PLANT_CROP.get() && EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)this.getBoundingBox(), new EntityPredicate((Entity)this).is(this.getType())).isEmpty()) {
            this.level().destroyBlock(this.blockPosition().above(), true);
        }
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<ThornyPlantSproutEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(50.0).moveSpeed(0.0).meleeStrength(8.0).knockbackResist(1.0).followRange(8.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "living", 0, event -> event.setAndContinue(this.tickCount < 20 ? DefaultAnimations.SPAWN : DefaultAnimations.IDLE)), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)AoAAnimations.ATTACK_SWIPE_RIGHT).transitionLength(0)});
    }
}

