/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.misc.BasicMiscEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SandGiantSpikeTrapEntity
extends BasicMiscEntity {
    private static final EntityPredicate<Entity> damagePredicate = new EntityPredicate().isAlive().isNot((EntityType)AoAMonsters.SAND_GIANT.get()).isDamageable();

    public SandGiantSpikeTrapEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SandGiantSpikeTrapEntity(Level level, Vec3 pos) {
        super((EntityType)AoAMiscEntities.SAND_GIANT_SPIKE_TRAP.get(), level);
        this.setPos(pos);
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.tickCount > 6000) {
                this.discard();
                return;
            }
            if (this.tickCount > 28 && this.tickCount % 10 == 0) {
                for (Entity entity : EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)this.getBoundingBox(), damagePredicate)) {
                    entity.hurt(this.level().damageSources().stalagmite(), 3.0f);
                }
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.getSpawnController((GeoAnimatable)this, state -> this, (int)41));
    }
}

