/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.misc.BasicMiscEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SandGiantPitTrapEntity
extends BasicMiscEntity {
    private static final EntityPredicate<LivingEntity> damagePredicate = new EntityPredicate().isAlive().isSubtypeOf(LivingEntity.class).isNot((EntityType)AoAMonsters.SAND_GIANT.get()).isDamageable();

    public SandGiantPitTrapEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SandGiantPitTrapEntity(Level level, Vec3 pos) {
        super((EntityType)AoAMiscEntities.SAND_GIANT_PIT_TRAP.get(), level);
        this.setPos(pos);
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.tickCount > 6000) {
                this.discard();
                return;
            }
            if (this.tickCount > 13 && this.tickCount % 5 == 0) {
                for (LivingEntity entity : EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)this.getBoundingBox(), damagePredicate)) {
                    entity.resetFallDistance();
                    entity.addEffect(new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 12).level(5).hideEffectIcon().hideParticles().isAmbient().build());
                }
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.getSpawnController((GeoAnimatable)this, state -> this, (int)41));
    }
}

