/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LootUtil;
import org.jetbrains.annotations.Nullable;

public class LottoTotemEntity
extends Entity
implements OwnableEntity {
    private UUID winnerUUID = null;
    private UUID ownerUUID = null;

    public LottoTotemEntity(Level world, BlockPos pos, UUID winnerUUID, UUID ownerUUID) {
        this((EntityType<? extends Entity>)((EntityType)AoAMiscEntities.LOTTO_TOTEM.get()), world);
        this.winnerUUID = winnerUUID;
        this.ownerUUID = ownerUUID;
        VoxelShape floorShape = world.getBlockState(pos).getShape((BlockGetter)world, pos);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + floorShape.max(Direction.Axis.Y), (double)pos.getZ() + 0.5);
    }

    public LottoTotemEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
        this.blocksBuilding = true;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return this.tickCount >= 12000 || !this.level().isClientSide && (this.ownerUUID == null || player.getUUID().equals(this.ownerUUID)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (this.isAlive() && (this.ownerUUID == null || player.getUUID().equals(this.ownerUUID))) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (this.winnerUUID != null && this.winnerUUID.equals(this.getUUID())) {
                    for (ItemStack stack : LootUtil.generateLoot(AdventOfAscension.id("misc/lotto_totem"), LootUtil.getGiftParameters(serverPlayer.serverLevel(), this.position(), 5.0f, (Entity)serverPlayer))) {
                        ItemEntity drop = this.spawnAtLocation(stack, 0.0f);
                        if (drop != null) {
                            drop.setThrower((Entity)serverPlayer);
                        }
                        AdvancementUtil.grantCriterion(serverPlayer, AdventOfAscension.id("completionist/winner_winner"), "lotto_win");
                    }
                    ItemEntity drop = this.spawnAtLocation(new ItemStack((ItemLike)AoABlocks.LOTTO_BANNER.base()), 0.0f);
                    if (drop != null) {
                        drop.setThrower((Entity)serverPlayer);
                    }
                    this.level().playSound(null, this.blockPosition(), (SoundEvent)AoASounds.LOTTO_WIN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                for (LottoTotemEntity totem : this.level().getEntitiesOfClass(LottoTotemEntity.class, new AABB(this.blockPosition()).inflate(2.0))) {
                    totem.discard();
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        if (this.level().isClientSide && !this.isAlive()) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 0.3, this.getZ(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("WinningUUID")) {
            this.winnerUUID = compound.getUUID("WinningUUID");
        }
        if (compound.hasUUID("OwnerUUID")) {
            this.ownerUUID = compound.getUUID("OwnerUUID");
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (this.winnerUUID != null) {
            compound.putUUID("WinningUUID", this.winnerUUID);
        }
        if (this.ownerUUID != null) {
            compound.putUUID("OwnerUUID", this.ownerUUID);
        }
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return ((Item)AoAItems.LOTTO_TOTEM.get()).getDefaultInstance();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return !source.is(Tags.DamageTypes.IS_TECHNICAL);
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        this.level().getProfiler().push("entityBaseTick");
        if (this.getY() < -64.0) {
            this.onBelowWorld();
        }
        this.level().getProfiler().pop();
    }
}

