/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class CustomisableLightningBolt
extends LightningBolt {
    protected boolean doFire = true;
    protected Consumer<Entity> onEntityStrike = null;

    public CustomisableLightningBolt(EntityType<? extends CustomisableLightningBolt> entityType, Level level) {
        super(entityType, level);
    }

    public CustomisableLightningBolt(Level level, BlockPos pos) {
        this(level, pos.getX(), pos.getY(), pos.getZ());
    }

    public CustomisableLightningBolt(Level level, double x, double y, double z) {
        this((EntityType<? extends CustomisableLightningBolt>)((EntityType)AoAMiscEntities.CUSTOMISABLE_LIGHTNING_BOLT.get()), level);
        this.moveTo(x, y, z);
    }

    public void noFire() {
        this.doFire = false;
    }

    public void whenStrikingEntity(Consumer<Entity> consumer) {
        this.onEntityStrike = consumer;
    }

    public void tick() {
        List entities;
        this.baseTick();
        if (this.life == 2) {
            if (this.level().isClientSide()) {
                if (!this.isSilent()) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10.0f, 0.8f + this.random.nextFloat() * 0.2f, false);
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 1.0f, 0.5f + this.random.nextFloat() * 0.2f, false);
                }
            } else {
                Difficulty difficulty = this.level().getDifficulty();
                if ((difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) && this.doFire) {
                    this.spawnFire(4);
                }
                this.powerLightningRod();
                CustomisableLightningBolt.clearCopperOnLightningStrike((Level)this.level(), (BlockPos)this.getStrikePosition());
                this.gameEvent((Holder)GameEvent.LIGHTNING_STRIKE);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                if (this.level() instanceof ServerLevel) {
                    entities = EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)new AABB(this.getX() - 15.0, this.getY() - 15.0, this.getZ() - 15.0, this.getX() + 15.0, this.getY() + 21.0, this.getZ() + 15.0), new EntityPredicate((Entity)this).isAlive().notInCollection(this.hitEntities));
                    for (ServerPlayer player2 : ((ServerLevel)this.level()).getPlayers(player -> player.distanceTo((Entity)this) < 256.0f)) {
                        CriteriaTriggers.LIGHTNING_STRIKE.trigger(player2, (LightningBolt)this, entities);
                    }
                }
                this.discard();
            } else if (this.life < -this.random.nextInt(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                if (this.doFire) {
                    this.spawnFire(0);
                }
            }
        }
        if (this.life >= 0) {
            if (!(this.level() instanceof ServerLevel)) {
                this.level().setSkyFlashTime(2);
            } else if (!this.visualOnly) {
                entities = EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)new AABB(this.getX() - 3.0, this.getY() - 3.0, this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 9.0, this.getZ() + 3.0), new EntityPredicate((Entity)this).isAlive());
                for (Entity entity : entities) {
                    if (EventHooks.onEntityStruckByLightning((Entity)entity, (LightningBolt)this)) continue;
                    entity.thunderHit((ServerLevel)this.level(), (LightningBolt)this);
                    if (this.onEntityStrike == null) continue;
                    this.onEntityStrike.accept(entity);
                }
                this.hitEntities.addAll(entities);
                if (this.cause != null) {
                    CriteriaTriggers.CHANNELED_LIGHTNING.trigger(this.cause, (Collection)entities);
                }
            }
        }
    }
}

